//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsCompiler.cpp
 * @brief		AsCompiler t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsCompiler_CPP_

//======================================================================
// include
#include "AsCompiler.h"
#include "../../fnd/memory/FndMemBuffer.h"
#include "../../fnd/io/FndFile.h"
#include "../../iris_tchar.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsCompiler::CAsCompiler(void)
	: m_pModule(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsCompiler::~CAsCompiler(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	module	= W[
 * @return	
*//***********************************************************************/
bool CAsCompiler::Initialize(asIScriptModule* module)
{
	if( module == nullptr ) return false;
	asIScriptEngine* engine = module->GetEngine();
	if( engine == nullptr ) return false;
	m_pModule = module;
	return true;
}

/**********************************************************************//**
 *
 * CN[h
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@CpX
 * @return	
*//***********************************************************************/
int CAsCompiler::Include(const char* lpszFileName)
{
	if( m_pModule == nullptr ) return asNO_MODULE;
	fnd::CFile file;
	if( !file.Open(lpszFileName, fnd::FOPEN_READ) ) return asERROR;
	u32 size = file.GetSize();
	fnd::CMemBuffer buf;
	buf.Alloc(size);
	file.Read(buf, size);
	int r = Preprocess(buf, size);
	if( AS_FAILED(r) ) return r;
	r = m_pModule->AddScriptSection(lpszFileName, static_cast<const char*>(buf.GetAddr()), size);
	return r;
}

/**********************************************************************//**
 *
 * rh
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CAsCompiler::Build(void)
{
	IRIS_ASSERT(m_pModule != nullptr);
	int ret = m_pModule->Build();
	return ret;
}

/**********************************************************************//**
 *
 * vvZX
 *
 -----------------------------------------------------------------------
 * @param [in]	buf		= obt@
 * @param [in]	size	= TCY
 * @return	
*//***********************************************************************/
int CAsCompiler::Preprocess(void* buf, u32 size)
{
	IRIS_ASSERT(m_pModule != nullptr);
	char* p = static_cast<char*>(buf);

	if( p == nullptr ) return asERROR;

	while(*p != '\0')
	{
		char* top = p;
		// skip whitespace
		p = strskipws(p);

		if( strncmp(p, "#include", 8) == 0 )
		{
			p += 8;
			p = strskipws(p);
			if( *p == '\"' )
			{
				++p;
				char path[MAX_PATH];
				for( int i=0; i < MAX_PATH; ++i )
				{
					path[i] = *p;
					++p;
					if( *p == '\"' || *p == '\n' || *p == '\0' ) break;
				}
				// include
				int r = Include(path);
				if( AS_FAILED(r) ) return r;
				// RgAEg
				*top = '/';
				*(top+1) = '/';
			}
		}

		p = strchr(p, '\n');
		if( p == nullptr ) break;
		++p;
	}
	return asSUCCESS;
}

}	// end of namespace as
}	// end of namespace iris

#endif
