//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsCompiler.h
 * @brief		angelscript RpC t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsCompiler_H_
#define INCG_IRIS_AsCompiler_H_

//======================================================================
// include
#include "AsModule.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript Compiler NX
*/
class CAsCompiler : public INonCopyable<CAsCompiler>
{
	asIScriptModule*	m_pModule;	//!< W[
public:
	// RXgN^
	CAsCompiler(void);
	// fXgN^
	~CAsCompiler(void);

public:
	// 
	bool	Initialize(asIScriptModule* module);
	// t@CCN[h
	int		Include(const char* lpszFileName);
	// rh
	int		Build(void);

public:
	// W[̐ݒ
	void	SetModule(asIScriptModule* module)	{ m_pModule = module; }
	// W[̎擾
	asIScriptModule*	GetModule(void)	const	{ return m_pModule; }

private:
	// vvZX
	int		Preprocess(void* buf, u32 size);
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
