//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsContext.h
 * @brief		angelscript ReLXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsContext_H_
#define INCG_IRIS_AsContext_H_

//======================================================================
// include
#include "AsVariant.h"
#include "fnd/container/FndObserver.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript Context NX
*/
class CAsContext : public fnd::CObserver<CAsContext>
{
	friend class CAsSystem;
protected:
	asIScriptContext*	m_pContext;	//!< ReLXg

public:
	// RXgN^
	CAsContext(void);
	// fXgN^
	~CAsContext(void);

public:
	// ֐IDݒ
	int		Prepare(int funcId);
	int		Prepare(asIScriptFunction* func);
	// 
	int		Unprepare(void);

	// o^
	template<typename T>
	void	SetArgument(asUINT arg, T value);
	// ɃAhXo^
	void	SetArgAddress(asUINT arg, void* addr);
	// ɃIuWFNgo^
	void	SetArgObject(asUINT arg, void* obj);

	// ߂l̎擾
	CAsVariant	GetReturnValue(int type) const;

public:
	// 
	int		Execute(void);
	// ~
	int		Suspend(void);
	// I
	void	Terminate(void);
	// ~
	void	Abort(void);

	// LȏԂǂ
	bool	IsValid(void)	const;

public:
	// O擾
	LPCSTR	GetExceptionString(void);
	// O֐ID擾
	int		GetExceptionFunction(void);
	// OC擾
	int		GetExceptionLineNumber(int* column=nullptr, const char** sectionName=nullptr);
	// OR[obN֐̐ݒ
	int		SetExceptionCallback(asSFuncPtr callback, void *obj, int callConv);

public:
	const asIScriptContext*	GetContext(void)	const	{ return m_pContext; }
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
