//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsError.h
 * @brief		angelscript G[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsError_H_
#define INCG_IRIS_AsError_H_

//======================================================================
// include
#include "as_inchead.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// function
void	AsFormatMessage (int Error, LPTSTR lpBuf, size_t size);
void	AsFormatMessageA(int Error, LPSTR  lpBuf, size_t size);
void	AsFormatMessageW(int Error, LPWSTR lpBuf, size_t size);

}	// end of namespace as
}	// end of namespace iris

//======================================================================
// define
#ifdef _IRIS_DEBUG

#define SCAS_ERROR(Error)				do { if( AS_FAILED(Error) ) { TCHAR err_str[256]; ::iris::as::AsFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define SCAS_ERROR2(Error, comm)		do { if( AS_FAILED(Error) ) { TCHAR err_str[256]; ::iris::as::AsFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define SCAS_CHECK_RESULT(exp)			do { ASRESULT Error = (exp); if( AS_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::as::AsFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
										} } while(0)
#define SCAS_DO_CHECK_RESULT(exp, todo)	do { ASRESULT Error = (exp); if( AS_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::as::AsFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
										} } while(0)

#else

#define SCAS_ERROR(Error)				(void)(0)
#define SCAS_ERROR2(Error, comm)		(void)(0)
#define SCAS_CHECK_RESULT(exp)			exp
#define SCAS_DO_CHECK_RESULT(exp, todo)	do { if( AS_FAILED(exp) ) { todo; } } while(0)

#endif

#endif

#endif
