//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsFunction.h
 * @brief		angelscript ֐IuWFNg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsFunction_H_
#define INCG_IRIS_AsFunction_H_

//======================================================================
// include
#include "AsSystem.h"
#include "AsVariant.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript Function NX
*/
class CAsFunction : public fnd::CObserver<CAsFunction>
{
protected:
	CAsContext	m_Context;	//!< ReLXg
	asIScriptFunction*	m_pFunction;	//!< ֐IuWFNg

public:
	// RXgN^
	CAsFunction(void);
	// fXgN^
	~CAsFunction(void);

public:
	// 
	bool	Initialize(CAsSystem& system, asIScriptModule* module, LPCTSTR name);
	// 
	void	Release(void);
	// LȃIuWFNgǂ
	bool	IsValid(void) const;

public:
	// ֐̂郂W[擾
	asIScriptModule*	GetModule(void) const;

public:
	// ֐̎s
	CAsVariant	operator()(void)
	{
		Execute();
		return GetReturnValue();
	}
	template<typename T1>
	CAsVariant	operator()(const T1& a1)
	{
		m_Context.SetArgument(0, a1);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2>
	CAsVariant	operator()(const T1& a1, const T2& a2)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4, const T5& a5)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		m_Context.SetArgument(4, a5);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4, const T5& a5, const T6& a6)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		m_Context.SetArgument(4, a5);
		m_Context.SetArgument(5, a6);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4, const T5& a5, const T6& a6, const T7& a7)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		m_Context.SetArgument(4, a5);
		m_Context.SetArgument(5, a6);
		m_Context.SetArgument(6, a7);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4, const T5& a5, const T6& a6, const T7& a7, const T8& a8)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		m_Context.SetArgument(4, a5);
		m_Context.SetArgument(5, a6);
		m_Context.SetArgument(6, a7);
		m_Context.SetArgument(7, a8);
		Execute();
		return GetReturnValue();
	}
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8, typename T9>
	CAsVariant	operator()(const T1& a1, const T2& a2, const T3& a3, const T4& a4, const T5& a5, const T6& a6, const T7& a7, const T8& a8, const T9& a9)
	{
		m_Context.SetArgument(0, a1);
		m_Context.SetArgument(1, a2);
		m_Context.SetArgument(2, a3);
		m_Context.SetArgument(3, a4);
		m_Context.SetArgument(4, a5);
		m_Context.SetArgument(5, a6);
		m_Context.SetArgument(6, a7);
		m_Context.SetArgument(7, a8);
		m_Context.SetArgument(8, a9);
		Execute();
		return GetReturnValue();
	}

private:
	// ֐̎s
	void	Execute(void);

	// ߂l̎擾
	CAsVariant	GetReturnValue(void) const;
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
