//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsModule.cpp
 * @brief		angelscript W[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsModule_CPP_

//======================================================================
// include
#include "AsModule.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsModule::CAsModule(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsModule::~CAsModule(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	module	= W[
 * @return	
*//***********************************************************************/
bool CAsModule::Initialize(asIScriptModule* module)
{
	if( module == nullptr ) return false;
	m_object = module;
	return true;
}

/**********************************************************************//**
 *
 * ֐̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	funcId	= ֐ID
 * @return	֐
*//***********************************************************************/
LPCSTR CAsModule::GetFunctionName(int funcId) const
{
	if( m_object == nullptr ) return nullptr;
	asIScriptEngine* engine = m_object->GetEngine();
	if( engine == nullptr ) return nullptr;
	asIScriptFunction* func = engine->GetFunctionById(funcId);
	if( func == nullptr ) return nullptr;
	return func->GetName();
}

}	// end of namespace as
}	// end of namespace iris

#endif
