//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsModule.h
 * @brief		angelscript W[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsModule_H_
#define INCG_IRIS_AsModule_H_

//======================================================================
// include
#include "as_inchead.h"
#include "../../fnd/container/FndWrapObject.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript Module NX
*/
class CAsModule : public fnd::CWrapObject<asIScriptModule*>
{
	typedef fnd::CWrapObject<asIScriptModule*>	_Mybase;
public:
	// RXgN^
	CAsModule(void);
	// fXgN^
	~CAsModule(void);

public:
	// 
	bool	Initialize(asIScriptModule* module);

	// ֐̎擾
	LPCSTR	GetFunctionName(int funcId) const;

public:
	CAsModule&	operator =	(asIScriptModule* obj)	{ m_object = obj; return *this; }
	CAsModule&	operator =	(const CAsModule& obj)	{ m_object = obj.m_object; return *this; }
#if	defined(_IRIS_HAS_NULLPTR_T)
	CAsModule&	operator =	(const nullptr_t& null)	{ m_object = null; return *this; }
#endif
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
