//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsSystem.cpp
 * @brief		angelscript VXe t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsSystem_CPP_

//======================================================================
// include
#include "AsSystem.h"
#include "AsAddOn.h"
#include <string>
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

//======================================================================
// link
#if	defined(IRIS_MSC)

#pragma comment (lib, "angelscript_static_"	\
				IRIS_LIB_MODE		\
				IRIS_LIB_VCVER		\
				IRIS_LIB_X64		\
				IRIS_LIB_POSTFIX	\
				".lib")
#endif


namespace iris {
namespace as
{

namespace 
{

/**********************************************************************//**
 *
 * RpCbZ[WR[obN
 *
*//***********************************************************************/
static void OnBuildMessageCallback(const asSMessageInfo *msg, void *param)
{
	const char* type = "ERR ";
	switch( msg->type )
	{
	case asMSGTYPE_WARNING:
		type = "WARN";
		break;
	case asMSGTYPE_INFORMATION:
		type = "INFO";
		break;
	}

	printf("%s (%d, %d) : %s : %s\n", msg->section, msg->row, msg->col, type, msg->message);
}

// W֐
void asPrint(std::string& msg)
{
	printf(msg.c_str());
}
void asPrintf(std::string& fmt, ...)
{
	va_list va;
	va_start(va, fmt);
	vprintf(fmt.c_str(), va);
	va_end(va);
}
void asPrintf1(std::string& fmt, int n1) { printf(fmt.c_str(), n1); }
void asPrintf2(std::string& fmt, int n1, int n2) { printf(fmt.c_str(), n1, n2); }
void asPrintf3(std::string& fmt, int n1, int n2, int n3) { printf(fmt.c_str(), n1, n2, n3); }
void asPrintf4(std::string& fmt, int n1, int n2, int n3, int n4) { printf(fmt.c_str(), n1, n2, n3, n4); }
void asPrintf5(std::string& fmt, int n1, int n2, int n3, int n4, int n5) { printf(fmt.c_str(), n1, n2, n3, n4, n5); }
void asPrintf6(std::string& fmt, int n1, int n2, int n3, int n4, int n5, int n6) { printf(fmt.c_str(), n1, n2, n3, n4, n5, n6); }
void asPrintf7(std::string& fmt, int n1, int n2, int n3, int n4, int n5, int n6, int n7) { printf(fmt.c_str(), n1, n2, n3, n4, n5, n6, n7); }
void asPrintf8(std::string& fmt, int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8) { printf(fmt.c_str(), n1, n2, n3, n4, n5, n6, n7, n8); }
void asPrintf9(std::string& fmt, int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) { printf(fmt.c_str(), n1, n2, n3, n4, n5, n6, n7, n8, n9); }
void asPrintf10(std::string& fmt, int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) { printf(fmt.c_str(), n1, n2, n3, n4, n5, n6, n7, n8, n9, n10); }

}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsSystem::CAsSystem(void)
: m_pEngine(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsSystem::~CAsSystem(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * VXe
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CAsSystem::Initialize(void)
{
	m_pEngine = asCreateScriptEngine( ANGELSCRIPT_VERSION );
	if( m_pEngine == nullptr ) return false;
	m_pEngine->SetMessageCallback(asFUNCTION(OnBuildMessageCallback), nullptr, asCALL_CDECL);

	// add_on
	{
		CAsAddOn::Register(m_pEngine);
	}
	// ֐o^
	{
		m_pEngine->RegisterGlobalFunction("void print(string &in)", asFUNCTION(asPrint), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in)", asFUNCTION(asPrint), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int)", asFUNCTION(asPrintf1), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int)", asFUNCTION(asPrintf2), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int)", asFUNCTION(asPrintf3), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int)", asFUNCTION(asPrintf4), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int)", asFUNCTION(asPrintf5), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int, int)", asFUNCTION(asPrintf6), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int, int, int)", asFUNCTION(asPrintf7), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int, int, int, int)", asFUNCTION(asPrintf8), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int, int, int, int, int)", asFUNCTION(asPrintf9), asCALL_CDECL);
		m_pEngine->RegisterGlobalFunction("void printf(string &in, int, int, int, int, int, int, int, int, int, int)", asFUNCTION(asPrintf10), asCALL_CDECL);
	}
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CAsSystem::Terminate(void)
{
	// context ̏I
	DetachObserverAll();
	IRIS_SAFE_RELEASE(m_pEngine);
}

/**********************************************************************//**
 *
 * ReLXg쐬
 *
 -----------------------------------------------------------------------
 * @param [out]	context	= o
 * @return	
*//***********************************************************************/
bool CAsSystem::CreateContext(CAsContext &context)
{
	context.Terminate();
	IRIS_ASSERT( m_pEngine != nullptr );
	asIScriptContext* p = m_pEngine->CreateContext();
	if( p == nullptr ) return false;
	context.m_pContext = p;
	context.SetExceptionCallback(asMETHOD(CAsSystem, ExceptionCallback), this, asCALL_THISCALL);
	AttachObserver(&context);
	return true;
}

/**********************************************************************//**
 *
 * W[̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszModuleName	= W[
 * @return	W[
*//***********************************************************************/
asIScriptModule* CAsSystem::CreateModule(LPCSTR lpszModuleName)
{
	IRIS_ASSERT( m_pEngine != nullptr );
	return m_pEngine->GetModule(lpszModuleName, asGM_CREATE_IF_NOT_EXISTS);
}

/**********************************************************************//**
 *
 * W[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszModuleName	= W[
 * @return	W[
*//***********************************************************************/
asIScriptModule* CAsSystem::GetModule(LPCSTR lpszModuleName)
{
	IRIS_ASSERT( m_pEngine != nullptr );
	return m_pEngine->GetModule(lpszModuleName);
}

/**********************************************************************//**
 *
 * ֐̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	funcId	= ֐ID
 * @return	֐
*//***********************************************************************/
LPCSTR CAsSystem::GetFunctionName(int funcId) const
{
	return GetFunctionName(m_pEngine, funcId);
}

/**********************************************************************//**
 *
 * ֐̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	funcId	= ֐ID
 * @return	֐
*//***********************************************************************/
LPCSTR CAsSystem::GetFunctionName(asIScriptEngine* engine, int funcId)
{
	if( engine == nullptr ) return nullptr;
	asIScriptFunction* func = engine->GetFunctionById(funcId);
	if( func == nullptr ) return nullptr;
	return func->GetName();
}

/**********************************************************************//**
 *
 * OR[obN
 *
 -----------------------------------------------------------------------
 * @param [in]	context	= ReLXg
*//***********************************************************************/
void CAsSystem::ExceptionCallback(asIScriptContext* context)
{
	printf("angelscript exception occurred: ");
	int line, column;
	line = context->GetExceptionLineNumber(&column);
	int funcId = context->GetExceptionFunction();
	const char* func = GetFunctionName(funcId);
	if( func != nullptr )
	{
		printf("%s(%d, %d): ", func, line, column);
	}
	else
	{
		printf("(%d, %d): ", line, column);
	}
	const char* str = context->GetExceptionString();
	if( str != nullptr ) printf(str);
}

/**********************************************************************//**
 *
 * ReLXg Detach
 *
 -----------------------------------------------------------------------
 * @param [in]	context	= f^b`ReLXg
*//***********************************************************************/
void CAsSystem::OnDetach(CAsContext* context)
{
	IRIS_ASSERT( context != nullptr );
	context->Terminate();
}

}	// end of namespace as
}	// end of namespace iris

#endif
