//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsVM.cpp
 * @brief		angelscript Virtual Machine t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsVM_CPP_

//======================================================================
// include
#include "AsVM.h"
#include "AsException.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsVM::CAsVM(CAsSystem& system)
: m_rSystem(system)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsVM::~CAsVM(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	compiler	= RpC
 * @return	
*//***********************************************************************/
bool CAsVM::Initialize(const CAsCompiler& compiler)
{
	if( m_Context.IsValid() ) return true;	// łɏς

	// W[擾
	asIScriptModule* module = compiler.GetModule();
	if( module == nullptr ) return false;
	asIScriptEngine* engine = module->GetEngine();
	if( engine == nullptr ) return false;
	if( !m_Module.Initialize(module) ) return false;
	
	// ReLXg쐬
	if( !m_rSystem.CreateContext(m_Context) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * s
 *
 -----------------------------------------------------------------------
 * @param [in]	entry	= Gg[֐
 * @return	
*//***********************************************************************/
int CAsVM::Run(const char* entry)
{
	IRIS_ASSERT( m_Context.IsValid() );
	// O
	asIScriptFunction* func = m_Module->GetFunctionByName(entry);
	if( func == nullptr )
	{
		// `
		func = m_Module->GetFunctionByDecl(entry);
		if( func = nullptr )
		{
			return asNO_FUNCTION;
		}
	}

	int ret = m_Context.Prepare(func);
	if( AS_FAILED(ret) ) return ret;

	while(1)
	{
		int ret = m_Context.Execute();

		if( ret == asEXECUTION_FINISHED )
		{
			const char* p = m_Context.GetExceptionString();
			if( p != nullptr )
			{
#if _IRIS_ANGELSCRIPT_HAS_EXCEPTION
				int line, column;
				line = m_Context.GetExceptionLineNumber(&column);
				int funcId = m_Context.GetExceptionFunction();
				throw as_exception(p, m_Module.GetFunctionName(funcId), line, column);
#endif
				return asERROR;
			}
			break;
		}
	}
	return asSUCCESS;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CAsVM::Terminate(void)
{
	m_Context.Terminate();
	m_Module = nullptr;
}

/**********************************************************************//**
 *
 * LȃIuWFNgǂ
 *
 -----------------------------------------------------------------------
 * @param [out]	func	= ֐IuWFNg
 * @return	
*//***********************************************************************/
bool CAsVM::IsValid(void) const
{
	if( !m_Context.IsValid() ) return false;
	return m_Module.is_valid();
}

/**********************************************************************//**
 *
 * Functor ̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [out]	func	= ֐IuWFNg
 * @param [in]	name	= ֐
 * @return	
*//***********************************************************************/
bool CAsVM::MakeFunctor(CAsFunction& func, LPCSTR name) const
{
	if( !IsValid() ) return false;
	if( !func.Initialize(m_rSystem, m_Module, name) ) return false;
	return true;
}

}	// end of namespace as
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) ) || defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CAsVMUnitTest, UserSelect)
{
	char path[MAX_PATH] = "../../../data/script/angelscript/hello.as";

#if defined(_IRIS_SUPPORT_AUTO_UNITTEST)
#else
	std::clog << "angelscript t@Cw" << std::endl;
	std::tcin >> path;
#endif

	{
		// system
		CAsSystem system;
		system.Initialize();

		// compile
		CAsCompiler compiler;
		compiler.Initialize(system.CreateModule("test"));
		compiler.Include(path);
		compiler.Build();

		// context
		CAsVM vm(system);
		vm.Initialize(compiler);
		vm.Run("main");
	}
}

#endif

#endif
