//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsVM.h
 * @brief		angelscript VXe t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsVM_H_
#define INCG_IRIS_AsVM_H_

//======================================================================
// include
#include "AsSystem.h"
#include "AsCompiler.h"
#include "AsFunction.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript Virtual Machine NX
*/
class CAsVM : public INonCopyable<CAsVM>
{
protected:
	CAsContext	m_Context;
	CAsModule	m_Module;
	CAsSystem&	m_rSystem;
public:
	// RXgN^
	CAsVM(CAsSystem& system);
	// fXgN^
	~CAsVM(void);

public:
	// 
	bool	Initialize(const CAsCompiler& compiler);
	// s
	int		Run(const char* entry);
	// I
	void	Terminate(void);

public:
	// LȃIuWFNgǂ
	bool	IsValid(void) const;
public:
	// Functor ̐ݒ
	bool	MakeFunctor(CAsFunction& func, LPCSTR name) const;
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
