//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		LuaState.cpp
 * @brief		LuaState t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_LuaState_CPP_

//======================================================================
// include
#include "LuaState.h"

#ifdef _IRIS_SUPPORT_LUA

namespace iris {
namespace lua
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CLuaState::CLuaState(void)
: m_pState(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CLuaState::~CLuaState(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * VK쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CLuaState::New(void)
{
	m_pState = luaL_newstate();
	return m_pState != nullptr;
}

/**********************************************************************//**
 *
 * 폜
 *
*//***********************************************************************/
void CLuaState::Delete(void)
{
	if( m_pState != nullptr )
	{
		lua_close(m_pState);
		m_pState = nullptr;
	}
}

/**********************************************************************//**
 *
 * VK쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFile	= t@CpX
 * @return	
*//***********************************************************************/
bool CLuaState::DoFile(LPCSTR lpszFile)
{
	if( !IsValid() ) return false;
	if( luaL_dofile(m_pState, lpszFile) )
	{
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * X^bN̎擾
 *
 ----------------------------------------------------------------------
 * @return	X^bN
*//***********************************************************************/
int CLuaState::GetStackCount(void) const
{
	return lua_gettop(m_pState);
}

#if defined(IRIS_WIN32)
/**********************************************************************//**
 *
 * X^bN̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	X^bN
*//***********************************************************************/
variant CLuaState::GetStack(int idx) const
{
	int type = lua_type(m_pState, idx);
	switch( type )
	{
	default:
	case LUA_TNIL:
		return variant();
	case LUA_TBOOLEAN:
		return variant( IRIS_TO_bool(lua_toboolean(m_pState, idx)) );
	case LUA_TNUMBER:
		return variant( lua_tonumber(m_pState, idx) );
	case LUA_TSTRING:
		return variant( lua_tostring(m_pState, idx) );
	}
}
#endif

/**********************************************************************//**
 *
 * X^bN̏o
 *
*//***********************************************************************/
void CLuaState::PrintStacks(void) const
{
	int num = GetStackCount();
	for( int i=0; i < num; ++i )
	{
		int type = lua_type(m_pState, i);
		switch( type )
		{
		case LUA_TNIL:
			printf("NIL\n");
			break;
		case LUA_TBOOLEAN:
			printf("BOOLEAN %s\n", lua_toboolean(m_pState, i) ? "true" : "false" );
			break;
		case LUA_TLIGHTUSERDATA:
			printf("LIGHTUSERDATA\n");
			break;
		case LUA_TNUMBER:
			printf("NUMBER  %lf\n", lua_tonumber(m_pState, i) );
			break;
		case LUA_TSTRING:
			printf("STRING  %s\n", lua_tostring(m_pState, i) );
			break;
		case LUA_TTABLE:
			printf("TABLE\n");
			break;
		case LUA_TFUNCTION:
			printf("FUNCTION\n");
			break;
		case LUA_TUSERDATA:
			printf("USERDATA\n");
			break;
		case LUA_TTHREAD:
			printf("THREAD\n");
			break;
		}
	}
}


}	// end of namespace lua
}	// end of namespace iris

#endif
