//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqCompiler.h
 * @brief		Squirrel Compiler t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqCompiler_H_
#define INCG_IRIS_SqCompiler_H_

//======================================================================
// include
#include "sq_inchead.h"
#include "../../iris_object.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// declare
class CSquirrelVM;

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @brief	squirrel RpCNX
*/
class CSqCompiler : public IIrisObject
{
	CSquirrelVM*	m_sq;
public:
	// RXgN^
	CSqCompiler(CSquirrelVM* sq);
public:
	SQRESULT	Compile(LPCSQSTR lpszFilename, SQBool raiseerror=SQTrue);
	SQRESULT	CompileBuffer(const SQChar *s, SQInteger size=-1, SQBool raiseerror=SQTrue, LPCSQSTR lpszName=NULL);
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
