//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqError.h
 * @brief		squirrel G[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqError_H_
#define INCG_IRIS_SqError_H_

//======================================================================
// include
#include "sq_inchead.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// function
void	SqFormatMessage (SQRESULT Error, LPTSTR lpBuf, size_t size);
void	SqFormatMessageA(SQRESULT Error, LPSTR  lpBuf, size_t size);
void	SqFormatMessageW(SQRESULT Error, LPWSTR lpBuf, size_t size);

}	// end of namespace sq
}	// end of namespace iris

//======================================================================
// define
#ifdef _IRIS_DEBUG

#define SCSQ_ERROR(Error)				do { if( SQ_FAILED(Error) ) { TCHAR err_str[256]; ::iris::sq::SqFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define SCSQ_ERROR2(Error, comm)		do { if( SQ_FAILED(Error) ) { TCHAR err_str[256]; ::iris::sq::SqFormatMessage(Error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define SCSQ_CHECK_RESULT(exp)			do { SQRESULT Error = (exp); if( SQ_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::sq::SqFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
										} } while(0)
#define SCSQ_DO_CHECK_RESULT(exp, todo)	do { SQRESULT Error = (exp); if( SQ_FAILED(Error) ) {				\
											TCHAR err_str[256]; iris::sq::SqFormatMessage(Error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
										} } while(0)

#else

#define SCSQ_ERROR(Error)				(void)(0)
#define SCSQ_ERROR2(Error, comm)		(void)(0)
#define SCSQ_CHECK_RESULT(exp)			exp
#define SCSQ_DO_CHECK_RESULT(exp, todo)	do { if( SQ_FAILED(exp) ) { todo; } } while(0)

#endif

#endif

#endif
