//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqScope.cpp
 * @brief		Squirrel Scope t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqScope_CPP_

//======================================================================
// include
#include "SqScope.h"
#include "SqVM.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSqScope::CSqScope(void)
: m_vm(nullptr)
, m_Top(0)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSqScope::CSqScope(HSQUIRRELVM vm)
: m_vm(nullptr)
, m_Top(0)
{
	Open(vm);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSqScope::CSqScope(CSquirrelVM* vm)
: m_vm(nullptr)
, m_Top(0)
{
	Open(vm->GetVM());
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSqScope::~CSqScope(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
void CSqScope::Open(HSQUIRRELVM vm)
{
	Close();
	IRIS_ASSERT( vm != nullptr );
	m_vm = vm;
	m_Top = sq_gettop(m_vm);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSqScope::Close(void)
{
	if( m_vm != nullptr )
	{
		sq_settop(m_vm, m_Top);
		Detach();
	}
}

/**********************************************************************//**
 *
 * f^b`
 *
*//***********************************************************************/
void CSqScope::Detach(void)
{
	m_vm = nullptr;
	m_Top = 0;
}

}	// end of namespace sq
}	// end of namespace iris

#endif
