//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqScope.h
 * @brief		Squirrel scope NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqScope_H_
#define INCG_IRIS_SqScope_H_

//======================================================================
// include
#include "sq_inchead.h"
#include "../../iris_object.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// declare
class CSquirrelVM;

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @brief	squirrel XR[v NX
*/
class CSqScope : public IIrisObject
{
protected:
	HSQUIRRELVM		m_vm;
	SQInteger		m_Top;
public:
	// RXgN^
	CSqScope(void);
	explicit CSqScope(HSQUIRRELVM vm);
	explicit CSqScope(CSquirrelVM* vm);
	// fXgN^
	~CSqScope(void);

public:
	void	Open(HSQUIRRELVM vm);
	void	Close(void);

public:
	void	Detach(void);
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
