//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqVM.h
 * @brief		squirrel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqVM_H_
#define INCG_IRIS_SqVM_H_

//======================================================================
// include
#include "sq_inchead.h"
#include "SqStack.h"
#include "call/SqFunctor.h"
#include "../../iris_variant.hpp"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @biref	squirrel VM NX
*/
class CSquirrelVM : private INonCopyable<>
{
private:
	HSQUIRRELVM	m_VM;	//!< z}V

public:
	// RXgN^
	CSquirrelVM(void);
	CSquirrelVM(HSQUIRRELVM vm);
	// fXgN^
	~CSquirrelVM(void);

public:
	// z}VJ
	void		Open(SQInteger initialstacksize=2048);
	// z}V
	void		Close(void);
	// JĂ邩ǂ
	bool		IsOpen(void)	const	{ return m_VM != nullptr; }

public:
public:
	// RpC
	SQRESULT	Compile(LPCSQSTR lpFile);
	SQRESULT	CompileBuffer(const SQChar *s, SQInteger size=-1, LPCSQSTR lpszName=NULL);
	// XNvg̃RpCƎs
	SQRESULT	DoFile(LPCSQSTR lpFile, SQBool retVal, SQBool printerror=SQTrue);
	// XNvg̎s
	SQRESULT	Run(SQBool retVal, SQBool printerror=SQTrue);

public:
	// ֐̎s
	SQRESULT	Exec(LPCSQSTR lpName, int num, ...);
	// ֐̌ĂяoGg
	CSqFunctor	Func(LPCSQSTR lpName);
	// ֐̓o^
	SQRESULT	RegisterFunction(SQFUNCTION func, LPCSQSTR lpName);

public:
	/// z}V̎擾
	HSQUIRRELVM	GetVM(void)	{ return m_VM; }
public:
	// wrap
	SQInteger	GetTop(void)	const		{ return sq_gettop(m_VM); }
	void		SetTop(SQInteger newtop)	{ sq_settop(m_VM, newtop); }

public:
	SQRESULT		Get(SQInteger idx)				const	{ return sq_get(m_VM, idx); }
	SQObjectType	GetType(SQInteger idx)			const	{ return CSqStack::GetType(m_VM, idx); }
	SQInteger		GetInteger(SQInteger idx)		const	{ return CSqStack::GetInteger(m_VM, idx); }
	SQBool			GetBool(SQInteger idx)			const	{ return CSqStack::GetBool(m_VM, idx); }
	SQFloat			GetFloat(SQInteger idx)			const	{ return CSqStack::GetFloat(m_VM, idx); }
	SQUserPointer	GetUserPointer(SQInteger idx)	const	{ return CSqStack::GetUserPointer(m_VM, idx); }
	LPCSQSTR		GetString(SQInteger idx)		const	{ return CSqStack::GetString(m_VM, idx); }
	HSQOBJECT		GetObjectHandle(SQInteger idx)	const	{ return CSqStack::GetObjectHandle(m_VM, idx); }
	SQUserPointer	GetUserData(SQInteger idx, SQUserPointer tag=0)		const { return CSqStack::GetUserData(m_VM, idx, tag); }
	SQUserPointer	GetInstanceUp(SQInteger idx, SQUserPointer tag)		const { return CSqStack::GetInstanceUp(m_VM, idx, tag); }

	template<typename TN>
	TN				GetValue(SQInteger idx)		const	{ return CSqStack::GetValue<TN>(m_VM, idx); }

	SQInteger		GetState(void)				const	{ return sq_getvmstate(m_VM); }
public:
	void		PushRootTable(void)				{ sq_pushroottable(m_VM); }
	void		Push(SQInteger idx)				{ sq_push(m_VM, idx); }
	void		Pop(SQInteger nelemstopop)		{ sq_pop(m_VM, nelemstopop); }
	void		PushInteger(SQInteger n)					{ CSqStack::PushInteger(m_VM, n); }
	void		PushBool(SQBool b)							{ CSqStack::PushBool(m_VM, b); }
	void		PushFloat(SQFloat f)						{ CSqStack::PushFloat(m_VM, f); }
	void		PushNull(void)								{ CSqStack::PushNull(m_VM); }
	void		PushUserPointer(SQUserPointer p)			{ CSqStack::PushUserPointer(m_VM, p); }
	void		PushString(const SQChar* s, SQInteger len)	{ CSqStack::PushString(m_VM, s, len); }

	template<typename TN>
	void		PushValue(TN v)									{ CSqStack::PushValue(m_VM, v); }

	template<typename TN, size_t SIZE>
	void		PushValue(TN (&v)[SIZE])						{ for( size_t i=0; i < SIZE; ++i ) PushValue(v[i]); return *this; }

	template<size_t SIZE>
	void		PushValue(const SQChar (&v)[SIZE])				{ return PushString(v, -1); }

	void		Remove(SQInteger idx)			{ sq_remove(m_VM, idx); }

public:
	SQUserPointer	NewUserPointer(SQUnsignedInteger size)					{ return sq_newuserdata(m_VM, size); }
public:
	SQRESULT	CreateSlot(SQInteger idx)									{ return sq_createslot(m_VM, idx); }
	void		NewClosure(SQFUNCTION func, SQUnsignedInteger nfreevars=0)	{ sq_newclosure(m_VM, func, nfreevars); }
	SQRESULT	SetNativeClosureName(SQInteger idx, const SQChar* name)		{ return sq_setnativeclosurename(m_VM, idx, name); }
	SQRESULT	Call(SQInteger params, SQBool retval, SQBool raiseerror)	{ return sq_call(m_VM, params, retval, raiseerror); }
	HSQUIRRELVM	NewThread(SQInteger initialstacksize)						{ return sq_newthread(m_VM, initialstacksize); }

public:
	/**
	 * @brief	TXyh
	*/
	SQRESULT	Suspend(void)	{ return sq_suspendvm(m_VM); }

	/**
	 * @brief	A
	*/
	SQRESULT	Wakeup(SQBool resumedret, SQBool retVal=SQFalse, SQBool printerror=SQFalse, SQBool throwerror=SQFalse)
	{
		return sq_wakeupvm(m_VM, resumedret, retVal, printerror, throwerror);
	}
	/**
	 * @brief	Ai߂lj
	*/
	template<typename TN>
	SQRESULT	WakeupMessage(TN ret, SQBool retVal=SQFalse, SQBool printerror=SQFalse, SQBool throwerror=SQFalse)
	{
		PushValue(ret);
		return Wakeup(SQTrue, retVal, printerror, throwerror);
	}

public:
	/**
	 * @brief	[eBeB
	*/
	class Utility : public IIrisObject
	{
	public:
		// TXyh
		static	SQInteger	Suspend(HSQUIRRELVM vm)	{ return sq_suspendvm(vm); }
		// _v֐
		static	SQInteger	DumpArgs(HSQUIRRELVM vm);
	};
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
