//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqFunctor.cpp
 * @brief		Squirrel ֐ĂяoNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqFunctor_CPP_

//======================================================================
// include
#include "SqFunctor.h"
#include "../SqVM.h"
#include "../../../iris_xchar.hpp"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	sq		= squirrel NX
 * @param [in]	lpName	= ֐
*//***********************************************************************/
CSqFunctor::CSqFunctor(CSquirrelVM* sq, LPCSQSTR lpName)
: m_sq(sq)
, m_args(0)
, m_top(-1)
{
	IRIS_ASSERT(sq != nullptr);
	Create(lpName);
}

/**********************************************************************//**
 *
 * Rs[RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	obj		= CSqFunctor NX
*//***********************************************************************/
CSqFunctor::CSqFunctor(CSqFunctor& obj)
: m_sq(obj.m_sq)
, m_top(obj.m_top)
, m_args(obj.m_args)
{
	obj.Reset();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSqFunctor::~CSqFunctor(void)
{
	if( IsValid() )
	{
		Finish();
	}
}

/**********************************************************************//**
 *
 * ֐ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName	= ֐(XR[vL)
*//***********************************************************************/
bool CSqFunctor::Create(LPCSQSTR lpName)
{
	IRIS_ASSERT(m_sq != nullptr);
	IRIS_ASSERT(lpName != nullptr);
	m_top = m_sq->GetTop();

	m_sq->PushRootTable();

	LPCSQSTR p = lpName;
	bool is_instance = false;
	while( 1 )
	{
		LPCSQSTR next = xcsstr(p, IRIS_XTEXT(SQChar, "::"));
		if( next == nullptr )
		{
			next = xcsstr(p, IRIS_XTEXT(SQChar, "->"));
			if( next == nullptr ) break;
			is_instance = true;
		}

		SQInteger length = next - p;
		m_sq->PushString(p, length);	// TODO : NULȂOKH
		if( SQ_FAILED(m_sq->Get(-2)) )
		{
			// 炸
			m_sq->SetTop(m_top);
			m_args = 0;
			return false;
		}
		p = next+2;
	}

	m_sq->PushString(p, -1);
	if( SQ_FAILED(m_sq->Get(-2)) )
	{
		// 炸
		m_sq->SetTop(m_top);
		m_args = 0;
		return false;
	}
	if( is_instance )
	{
		m_sq->Push(-2);
	}
	else
	{
		m_sq->PushRootTable();
	}
	m_args = 1;
	return true;
}

/**********************************************************************//**
 *
 * Zbg
 *
 ----------------------------------------------------------------------
 * @return	g
*//***********************************************************************/
CSqFunctor&	CSqFunctor::PushInteger(SQInteger n)
{
	if( IsValid() )
	{
		++m_args;
		m_sq->PushInteger(n);
	}
	return *this;
}
CSqFunctor&	CSqFunctor::PushBool(SQBool b)
{
	if( IsValid() )
	{
		++m_args;
		m_sq->PushBool(b);
	}
	return *this;
}
CSqFunctor&	CSqFunctor::PushFloat(SQFloat f)
{
	if( IsValid() )
	{
		++m_args;
		m_sq->PushFloat(f);
	}
	return *this;
}
CSqFunctor&	CSqFunctor::PushPointer(SQUserPointer p)
{
	if( IsValid() )
	{
		++m_args;
		m_sq->PushUserPointer(p);
	}
	return *this;
}
CSqFunctor&	CSqFunctor::PushString(const SQChar* s, SQInteger len)
{
	if( IsValid() )
	{
		++m_args;
		m_sq->PushString(s, len);
	}
	return *this;
}

/**********************************************************************//**
 *
 * ֐̎s
 *
 ----------------------------------------------------------------------
 * @param [in]	retVal	= ߂l̗L
 * @return	Ug
*//***********************************************************************/
SQRESULT CSqFunctor::Call(SQBool retVal)
{
	IRIS_ASSERT(IsValid());
	SQRESULT ret = m_sq->Call(m_args, retVal, SQTrue);
	return ret;
}

/**********************************************************************//**
 *
 * ߂l擾
 *
 ----------------------------------------------------------------------
 * @return	߂l
*//***********************************************************************/
template<>
SQInteger CSqFunctor::GetReturnValue<SQInteger>(void)
{
	IRIS_ASSERT( m_sq->GetType(-1) == OT_INTEGER );
	SQInteger ret = m_sq->GetInteger(-1);
	m_sq->Pop(1);
	return ret;
}

template<>
SQFloat CSqFunctor::GetReturnValue<SQFloat>(void)
{
	IRIS_ASSERT( m_sq->GetType(-1) == OT_FLOAT );
	SQFloat ret = m_sq->GetFloat(-1);
	m_sq->Pop(1);
	return ret;
}
template<>
void CSqFunctor::GetReturnValue<void>(void)
{
	IRIS_ASSERT( m_sq->GetType(-1) == OT_CLOSURE );
}

/**********************************************************************//**
 *
 * sI
 *
*//***********************************************************************/
void CSqFunctor::Finish(void)
{
	IRIS_ASSERT(IsValid());
	m_sq->SetTop(m_top);
	Reset();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CSqFunctor::Reset(void)
{
	m_args = 0;
	m_top = -1;
}


}	// end of namespace sq
}	// end of namespace iris


#endif
