//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqDelegator.cpp
 * @brief		Squirrel ֐ĂяoNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqDelegator_CPP_

//======================================================================
// include
#include "SqDelegator.h"
#include "../SqVM.h"
#include "../../../iris_xchar.hpp"
#include "../../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class

}	// end of namespace sq
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )// || defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../../unit/UnitCore.h"
#include "../../../iris_using.h"
#include "../../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CSqDelegateUnitTest, Delegate)
{
	CSquirrelVM sq;

	sq.Open(4096);
	ASSERT_TRUE( CSqDelegator::CreateGlobalFunction(&sq, _SC("printArgs"), CSquirrelVM::Utility::DumpArgs) );
#if 1
	sq.CompileBuffer(_SC(" printArgs(\"Hello\", 1, 0.1); \n"));
	sq.Run(SQFalse);
#else
	SQChar path[MAX_PATH] = _SC("../../../data/script/squirrel/callhost.nut");
	ASSERT_TRUE( SQ_SUCCEEDED(sq.DoFile(path, SQFalse)) );
#endif
}

static int	sq_add(int a, int b) { return a+b; }

IRIS_UNITTEST(CSqDelegateUnitTest, Delegate2)
{
	CSquirrelVM sq;

	sq.Open(4096);
	ASSERT_TRUE( CSqDelegator::CreateGlobalFunction(&sq, _SC("add"), sq_add) );

	ASSERT_TRUE( SQ_SUCCEEDED(sq.CompileBuffer(_SC(" local x = add(3, 5);\n print(x+\"\\n\"); \n"))) );
	ASSERT_TRUE( SQ_SUCCEEDED(sq.Run(SQFalse)) );
}


#endif

#endif
