//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		STLvectorex.h
 * @brief		vector g t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_STLvecmap_H_
#define INCG_IRIS_STLvecmap_H_

//======================================================================
// include
#include "iris_object.h"
#include <vector>

namespace iris {
namespace stl
{

//======================================================================
// class
//! gvector
template<class _Ty,
	class _Ax = allocator<_Ty> >
class vectorex : public std::vector< _Ty, _Ax >
{
public:
	typedef typename vectorex< _Ty, _Ax >		_Myt;
	typedef typename std::vector< _Ty, _Ax >	_Mybase;
public:

	template<typename _Ite>
	void push_back(_Ite begin, _Ite end)
	{
		for( ; begin != end; ++begin )
		{
			_Mybase::push_back(*begin);
		}
	}

	void push_back(const _Ty& _Val)
	{
		_Mybase::push_back(_Val);
	}
};

}	// end of namespace stl
}	// end of namespace iris

#endif
