//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types_matrix.h
 * @brief		iris_types_matrix t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_matrix_H_
#define INCG_IRIS_iris_types_matrix_H_

//======================================================================
// include
#include "iris_types_vector.hpp"

#if defined(__cplusplus)

//======================================================================
// declare
template<typename _TN>union IrisTMtx22;
template<typename _TN>union IrisTMtx33;
template<typename _TN>union IrisTMtx43;
template<typename _TN>union IrisTMtx44;

//======================================================================
// struct
//! 2x2}gbNX^
template<typename _TN>union IrisTMtx22
{
	struct
	{
		_TN _00, _01;
		_TN _10, _11;
	};
	struct
	{
		IrisTVec2<_TN>	x, y;
	};
	_TN	a[4];
	_TN m[2][2];
};
//! 3x3}gbNX^
template<typename _TN>union IrisTMtx33
{
	struct
	{
		_TN _00, _01, _02;
		_TN _10, _11, _12;
		_TN _20, _21, _22;
	};
	struct
	{
		IrisTVec3<_TN>	x, y, z;
	};
	_TN	a[9];
	_TN m[3][3];
};
//! 4x3}gbNX^
template<typename _TN>union IrisTMtx43
{
	struct
	{
		_TN _00, _01, _02;
		_TN _10, _11, _12;
		_TN _20, _21, _22;
		_TN _30, _31, _32;
	};
	struct
	{
		IrisTVec3<_TN>	x, y, z, w;
	};
	_TN	a[12];
	_TN m[4][3];
};
//! 4x4}gbNX^
template<typename _TN>union IrisTMtx44
{
	struct
	{
		_TN _00, _01, _02, _03;
		_TN _10, _11, _12, _13;
		_TN _20, _21, _22, _23;
		_TN _30, _31, _32, _33;
	};
	struct
	{
		IrisTVec4<_TN>	x, y, z, w;
	};
	_TN	a[16];
	_TN m[4][4];
};

#endif

#endif
