//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types_vector.h
 * @brief		iris_types_vector t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_vector_H_
#define INCG_IRIS_iris_types_vector_H_

//======================================================================
// include
#include "iris_types_alias.h"

#if defined(__cplusplus)

//======================================================================
// declare
template<typename _TN>union IrisTVec2;
template<typename _TN>union IrisTVec3;
template<typename _TN>union IrisTVec4;
template<typename _TN, size_t D>struct IrisTVecN;

//======================================================================
// struct
//! 2DxNg^
template<typename _TN>union IrisTVec2
{
	struct { _TN x, y; };
	_TN	a[2];

	IrisTVec2() : x(0), y(0) {}
	IrisTVec2(const IrisTVec2<_TN>& obj) : x(obj.x), y(obj.y) {}
	template<typename _TT>
	IrisTVec2(const IrisTVec2<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y) {}
};
//! 3DxNg^
template<typename _TN>union IrisTVec3
{
	struct { _TN x, y, z; };
	_TN	a[3];

	IrisTVec3() : x(0), y(0), z(0) {}
	IrisTVec3(const IrisTVec3<_TN>& obj) : x(obj.x), y(obj.y), z(obj.z) {}
	template<typename _TT>
	IrisTVec3(const IrisTVec3<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y), z((_TN)obj.z) {}
};
//! 4DxNg^
template<typename _TN>union IrisTVec4
{
	struct { _TN x, y, z, w; };
	_TN	a[4];

	IrisTVec4() : x(0), y(0), z(0), w(0) {}
	IrisTVec4(const IrisTVec4<_TN>& obj) : x(obj.x), y(obj.y), z(obj.z), w(obj.w) {}
	template<typename _TT>
	IrisTVec4(const IrisTVec4<_TT>& obj) : x((_TN)obj.x), y((_TN)obj.y), z((_TN)obj.z), w((_TN)obj.w) {}
};
//! xNg^
template<typename _TN, size_t D>struct IrisTVecN
{
	_TN	a[D];

	IrisTVecN() { for( int i=0; i < D; ++i ) a[i] = 0; }
	IrisTVecN(const IrisTVecN<_TN, D>& obj) { for( int i=0; i < D; ++i ) a[i] = obj.a[i]; }
	template<typename _TT>
	IrisTVecN(const IrisTVecN<_TT, D>& obj) { for( int i=0; i < D; ++i ) a[i] = (_TN)obj.a[i]; }
};

#endif

#endif
