//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitCore.h
 * @brief		Unit Core t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitCore_H_
#define INCG_IRIS_UnitCore_H_

//======================================================================
// include
#include "UnitFuctory.h"
#include "UnitUtility.h"
#include "gt/gt_inchead.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

//======================================================================
// define
// UNITTEST_MAIN֐̍쐬	(UNITTEST_MAIN_FUNC)
// P̃eXgNX̒`	(IRIS_UNITTEST)
#define UNITTEST_MAIN_FUNC_NAME(tester, name)	tester##name

#ifndef _IRIS_MULTI_UNITTEST
#define UNITTEST_MAIN_FUNC(tester, name)		EXTERN_C void UNITTEST_MAIN_FUNC_NAME(tester, name)(void)
#define IRIS_UNITTEST_P(tester, parent, func)	UNITTEST_MAIN_FUNC(func)
#define IRIS_UNITTEST(tester, func)				UNITTEST_MAIN_FUNC(func)
#define IRIS_UNITTEST_FIX(tester, func)			UNITTEST_MAIN_FUNC(func)

#ifndef _IRIS_UNITTEST_FUNC
#define _IRIS_UNITTEST_FUNC		iris_main
#endif
UNITTEST_MAIN_FUNC(_IRIS_UNITTEST_FUNC);

#else
#define UNITTEST_CLASS_NAME(tester, name)		ut_##tester##_##name
#define IRIS_UNITTEST_(tester, parent, func)							\
	class UNITTEST_CLASS_NAME(tester, func) : public parent {			\
		public:	virtual void Body(void);								\
	};																	\
	static volatile ::iris::unit::CUnitTestFuctory<UNITTEST_CLASS_NAME(tester, func)>	\
	s_##tester##_##func(IRIS_TEXT( #tester ), IRIS_TEXT( #func ) );						\
	void UNITTEST_CLASS_NAME(tester, func)::Body(void)

#define IRIS_UNITTEST(tester, func)							\
	IRIS_UNITTEST_(tester, ::iris::unit::CUnitTest<UNITTEST_CLASS_NAME(tester, func)>, func)

#define IRIS_UNITTEST_F(tester, func)						\
	IRIS_UNITTEST_(tester, tester, func)

#define IRIS_UNITTEST_B(tester, base, func)						\
	IRIS_UNITTEST_(tester, base, func)

#endif

namespace iris {
namespace unit
{

}	// end of namespace unit
}	// end of namespace iris

#else

#if	defined(_IRIS_SUPPORT_GOOGLETEST)
#define UNITTEST_MAIN_FUNC(name)				__noop
#define IRIS_UNITTEST_P(tester, func)			TEST_P(tester, func)
#define IRIS_UNITTEST(tester, func)				TEST(tester, func)
#define IRIS_UNITTEST_F(tester, func)			TEST_F(tester, func)

#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
#  define _IRIS_SUPPORT_AUTO_UNITTEST
#endif

#else

#define UNITTEST_MAIN_FUNC(name)				__noop
#define IRIS_UNITTEST_P(tester, parent, func)	__noop
#define IRIS_UNITTEST(tester, func)				__noop
#define IRIS_UNITTEST_FIX(tester, func)			__noop

#endif

#endif

#endif
