//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		gt_inchead.h
 * @brief		google test include t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_gt_inchead_H_
#define INCG_IRIS_gt_inchead_H_

//======================================================================
// include
#include "../../iris_inchead.h"
#include "../UnitUtility.h"
#include "../../iris_debug.h"

#ifdef	_IRIS_SUPPORT_GOOGLETEST

/**
 * @defgroup google_test
*/

//======================================================================
// define
#if		defined(IRIS_MWERKS)
#  define GTEST_HAS_POSIX_RE		0
#  define GTEST_FATAL_FAILURE		::testing::TestPartResultType::TPRT_FATAL_FAILURE
#  define GTEST_NONFATAL_FAILURE	::testing::TestPartResultType::TPRT_NONFATAL_FAILURE
#  include <stdio.posix.h>
#endif

IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4365)	// signed/unsigned v܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4389)	// '!=' : signed  unsigned ̐lr悤Ƃ܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4626)	// {NX̑ZqɃANZXłȂ߁AZq͐ł܂łB
IRIS_MSC_PRAGMA_WARNING_DISABLE(4668)	// '#if/#elif'  '0' ɒuvvZbT }NƂĒ`Ă܂B
IRIS_MSC_PRAGMA_WARNING_DISABLE(4826)	// 'hoge' ւ̕ϊ͕gĂ܂B́A\Ȃs̓𔭐\܂B
#include <gtest/gtest.h>
IRIS_MSC_PRAGMA_WARNING_END()

#include "../../iris_iostream.h"

//======================================================================
// link
#if		defined(_WIN32) && defined(_MT)
#  pragma comment( lib, "gtest_" \
	IRIS_LIB_MODE		\
	IRIS_LIB_VCVER		\
	IRIS_LIB_AMD64		\
	IRIS_LIB_POSTFIX	\
	".lib" )

#endif

//======================================================================
// define
#define GT_INIT(pargc, argv)		::testing::InitGoogleTest(pargc, argv)

#undef ASSERT_TRUE
#define ASSERT_TRUE(condition) \
	GTEST_TEST_BOOLEAN_(condition ? true : false, #condition, false, true, \
                      GTEST_FATAL_FAILURE_)

#if	defined(IRIS_MSC)	// TODO : Ƃ肠AVC ̂

#ifndef GTEST_BREAK
#  define GTEST_BREAK()		if( IsDebuggerPresent() ) IRIS_SetBreakPoint()
#endif

#ifndef GTEST_FATAL_FAILURE
#  define GTEST_FATAL_FAILURE		::testing::TestPartResult::kFatalFailure
#endif
#ifndef GTEST_NONFATAL_FAILURE
#  define GTEST_NONFATAL_FAILURE	::testing::TestPartResult::kNonFatalFailure
#endif

#ifdef GTEST_FATAL_FAILURE_
#undef GTEST_FATAL_FAILURE_
#define GTEST_FATAL_FAILURE_(message) \
	do {\
	GTEST_BREAK();\
	return GTEST_MESSAGE_(message, GTEST_FATAL_FAILURE);\
	} while(0)
#endif

#ifdef GTEST_NONFATAL_FAILURE_
#undef GTEST_NONFATAL_FAILURE_
#define GTEST_NONFATAL_FAILURE_(message) \
	do {\
	GTEST_BREAK();\
	GTEST_MESSAGE_(message, GTEST_NONFATAL_FAILURE);\
	} while(0)
#endif

#endif

#else

//======================================================================
// define
#define EXPECT_TRUE(condition)		do { if( !(condition) ) { IRIS_WARNING( #condition); IRIS_SetBreakPoint(); } } while(0)
#define EXPECT_FALSE(condition)		do { if(  (condition) ) { IRIS_WARNING( #condition); IRIS_SetBreakPoint(); } } while(0)
#define ASSERT_TRUE(condition)		do { if( !(condition) ) { IRIS_ASSERT( (condition)); IRIS_SetBreakPoint(); } } while(0)
#define ASSERT_FALSE(condition)		do { if(  (condition) ) { IRIS_ASSERT(!(condition)); IRIS_SetBreakPoint(); } } while(0)

#define EXPECT_EQ(expected, actual) __noop
#define EXPECT_NE(expected, actual) __noop
#define EXPECT_LE(val1, val2)		__noop
#define EXPECT_LT(val1, val2)		__noop
#define EXPECT_GE(val1, val2)		__noop
#define EXPECT_GT(val1, val2)		__noop

#define ASSERT_EQ(expected, actual)	__noop
#define ASSERT_NE(val1, val2)		__noop
#define ASSERT_LE(val1, val2)		__noop
#define ASSERT_LT(val1, val2)		__noop
#define ASSERT_GE(val1, val2)		__noop
#define ASSERT_GT(val1, val2)		__noop

#define EXPECT_STREQ(expected, actual)		__noop
#define EXPECT_STRNE(s1, s2)				__noop
#define EXPECT_STRCASEEQ(expected, actual)	__noop
#define EXPECT_STRCASENE(s1, s2)			__noop

#define ASSERT_STREQ(expected, actual)		__noop
#define ASSERT_STRNE(s1, s2)				__noop
#define ASSERT_STRCASEEQ(expected, actual)	__noop
#define ASSERT_STRCASENE(s1, s2)			__noop

#define EXPECT_FLOAT_EQ(expected, actual)	__noop
#define EXPECT_DOUBLE_EQ(expected, actual)	__noop
#define ASSERT_FLOAT_EQ(expected, actual)	__noop
#define ASSERT_DOUBLE_EQ(expected, actual)	__noop
#define EXPECT_NEAR(val1, val2, abs_error)	__noop
#define ASSERT_NEAR(val1, val2, abs_error)	__noop

#define EXPECT_HRESULT_SUCCEEDED(expr)		__noop
#define ASSERT_HRESULT_SUCCEEDED(expr)		__noop
#define EXPECT_HRESULT_FAILED(expr)			__noop
#define ASSERT_HRESULT_FAILED(expr)			__noop

#if 0
#  define GTEST_TEST(test_case_name, test_name)		void test_case_name##_##test_name()
#  define TEST(test_case_name, test_name)			GTEST_TEST(test_case_name, test_name)
#  define TEST_F(test_fixture, test_name)			GTEST_TEST(test_fixture, test_name)
#else
#  include "../UnitCore.h"
#  define GTEST_TEST(test_case_name, test_name)		IRIS_UNITTEST(test_case_name, test_name)
#  define TEST(test_case_name, test_name)			GTEST_TEST(test_case_name, test_name)
#  define TEST_F(test_fixture, test_name)			IRIS_UNITTEST_FIX(test_fixture, test_name)
#endif

#define RUN_ALL_TESTS()						__noop
#define GT_INIT(pargc, argv)				__noop

//======================================================================
// class
/// @internal
namespace testing
{
	/// @internal
	class Test
	{
	};
}

#endif

#define NO_TEST(test_case_name, test_name)			void test_case_name##_##test_name()

#endif
