//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest.cpp
 * @brief		Multi Unit Test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitMultiUnitTest_CPP_

//======================================================================
// include
#include "UnitMultiUnitTest.h"

#ifdef _IRIS_MULTI_UNITTEST
#include "../../iris_iostream.h"
#include "../../iris_debug.h"
#include "../../iris_main.h"
#include "../../iris_global.h"
#include "../gt/gt_inchead.h"
#include "../../iris_tchar.h"

namespace iris {
namespace unit
{

//======================================================================
// typedef

//======================================================================
// static
CMultiUnitTester::UTMap CMultiUnitTester::s_UTMap;

//======================================================================
// class
// RXgN^
CMultiUnitTester::CMultiUnitTester(void)
{
	m_curr_dir[0] = '\0';
}

// 
bool	CMultiUnitTester::Initialize(void)
{
	// Xgo^
	IUnitTestFuctory* p = *IUnitTestFuctory::GetRegister();
	while(p)
	{
		s_UTMap.insert(UTPair(p->m_name, p));
		p = p->m_next;
	}
	return true;
}

// s
void	CMultiUnitTester::Run(void)
{
	while(1)
	{
		if( !UpdateCommand() ) break;
	}
}

// s
void	CMultiUnitTester::RunAll(void)
{
	for( UTMap::iterator it = s_UTMap.begin(), end = s_UTMap.end(); it != end; ++it )
	{
		// s
		_ftprintf(stderr, IRIS_TEXT("execute unit test. <%s>.\n"), it->first.c_str() );
		it->second->Exec();
#ifdef _WIN32
		FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );
#endif
		_ftprintf(stderr, IRIS_TEXT("done unit test. <%s>.\n"), it->first.c_str() );
	}
}

// NeLXg̏o
void	CMultiUnitTester::PutsFirstText(void)
{
	fprintf(stderr, "Please input the tested file name.\n");
	fprintf(stderr, "If \"list\" is input, the registered test name is displayed.\n");
	fprintf(stderr, "If \"quit\" is input, it ends.\n");
}

// t@C̍œK
void	CMultiUnitTester::FileNameOptimize(LPTSTR fname, int length)
{
	IRIS_UNUSED_VARIABLE(fname);
	IRIS_UNUSED_VARIABLE(length);
}

// R}h
bool	CMultiUnitTester::OnCommand(LPTSTR cmd, int size)
{
	IRIS_ASSERT( size > 4 );
	IRIS_UNUSED_VARIABLE(size);
	// Ȃɂsꍇ́AtrueԂ
	if( cmd[0] == IRIS_TEXT('n') && cmd[1] == IRIS_TEXT('o')
		&& cmd[2] == IRIS_TEXT('n') && cmd[3] == IRIS_TEXT('e') && cmd[4] == IRIS_TEXT('\0') ) return true;
	return false;
}

bool CMultiUnitTester::UpdateCommand(void)
{
	return false;
}

bool CMultiUnitTester::CommandProc(LPTSTR name)
{
	// R}h
	if( OnCommand(name, MAX_PATH) )
	{
		return true;
	}

	// DIɏ
	if( _tcsequ(name, IRIS_TEXT("quit")) ) return false;
	if( _tcsequ(name, IRIS_TEXT("list")) )
	{
		// Xg\
#ifdef _IRIS_DEBUG
		fprintf(stderr, "%d.\n", s_UTMap.size() );
#endif
		for( UTMap::iterator _it=s_UTMap.begin(), _end=s_UTMap.end(); _it != _end; ++_it )
		{
			_ftprintf(stderr, IRIS_TEXT("%s\n"), _it->first.c_str());
		}
		return true;
	}
	if( xcscmp(name, IRIS_TEXT("main")) == 0 )
	{
		iris_main();
		return true;
	}
#ifdef _IRIS_SUPPORT_GOOGLETEST
	if( xcscmp(name, IRIS_TEXT("googletest")) == 0 )
	{
		int argc = ::irisGetArgc();
		LPTSTR* argv = ::irisGetArgv();

		GT_INIT(&argc, argv);
		RUN_ALL_TESTS();
		return true;
	}
#endif

	// ̍œK
	FileNameOptimize(name, (int)_tcslen(name));

	// P̃eXg
	UTMap::iterator end = s_UTMap.end();
	//iterator it = fnd::dbg::s_UTMap.find(name);
	UTMap::iterator it = end;
	if( it == end )
	{
		// Ov
		bool many = false;
		for( UTMap::iterator tmp = s_UTMap.begin(); tmp != end; ++tmp )
		{
			LPCTSTR p = tmp->first.c_str();
			if( xcsstr( p, name ) == p )
			{
				if( it == end )
				{
					it = tmp;
				}
				else
				{
					_ftprintf(stderr, IRIS_TEXT("%s\n"), it->first.c_str() );
					it = tmp;
					many = true;
				}
			}
		}
		if( many )
		{
			// ₪ꍇ
			_ftprintf(stderr, IRIS_TEXT("%s\n"), it->first.c_str() );
			return true;
		}
	}
	if( it != end )
	{
		// s
		_ftprintf(stderr, IRIS_TEXT("execute unit test. <%s>.\n"), it->first.c_str() );
		it->second->Exec();
#ifdef _WIN32
		FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );
#endif
		_ftprintf(stderr, IRIS_TEXT("done unit test. <%s>.\n"), it->first.c_str() );
	}
	else
	{
		_ftprintf(stderr, IRIS_TEXT("failed unit test. <%s>.\n"), name);
	}
	return true;
}

}	// end of namespace unit
}	// end of namespace iris

#endif
