//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest.h
 * @brief		Multi Unit Test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitMultiUnitTest_H_
#define INCG_IRIS_UnitMultiUnitTest_H_

//======================================================================
// include
#include "../UnitFuctory.h"
#include "../../fnd/container/FndSingleton.h"

#ifdef _IRIS_MULTI_UNITTEST
#include <map>
#include <string>

namespace iris {
namespace unit
{

//======================================================================
// class
// multi unit test ǗNX
class CMultiUnitTester : public fnd::CSingleton<CMultiUnitTester>
{
public:
	typedef std::map <std::_tstring, IUnitTestFuctory*> UTMap;
	typedef std::pair<std::_tstring, IUnitTestFuctory*> UTPair;
protected:
	static UTMap	s_UTMap;
public:
	TCHAR m_curr_dir[MAX_PATH];
public:
	// RXgN^
	CMultiUnitTester(void);
	// fXgN^
	virtual ~CMultiUnitTester(void)	{ Release(); }

public:
	// 
	virtual bool	Initialize(void);
	// 
	virtual void	Release(void)	{}

public:
	// s
	virtual void	Run(void);
	// XV
	virtual bool	UpdateCommand(void);
	// s
	virtual void	RunAll(void);

public:
	// NeLXg̏o
	virtual void	PutsFirstText(void);
	// t@C̍œK
	virtual void	FileNameOptimize(LPTSTR fname, int length);
	// R}h
	virtual bool	OnCommand(LPTSTR cmd, int size);

protected:
	// R}h
	virtual bool	CommandProc(LPTSTR cmd);

public:
	// ftHgCX^X̍쐬
	static CMultiUnitTester&	CreateDefaultInstance(void)	{ static CMultiUnitTester inst; return inst; }
};


}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
