//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitUtPath.h
 * @brief		P̃eXg [eBeB eXgpX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitUtPath_H_
#define INCG_IRIS_UnitUtPath_H_

//======================================================================
// include
#include "../../iris_object.h"
#include "../../iris_xchar.hpp"

namespace iris {
namespace unit
{

//======================================================================
// decalre
template<typename CHARTYPE_>class CTUtPath;

//======================================================================
// typedef
typedef CTUtPath<CHAR>	CUtPathA;
typedef CTUtPath<WCHAR>	CUtPathW;
typedef CTUtPath<TCHAR>	CUtPath;

/**
 * @brief	eXgf[^pXNX
*/
template<typename CHARTYPE_>
class CTUtPath : public IIrisObject
{
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
protected:
	_Mychar	m_Path[IRIS_MAX_PATH];
public:
	CTUtPath(_Mylpcstr path)
	{
#if defined(IRIS_MSC)
		::GetEnvironmentVariable(IRIS_TEXT("IRIS_ROOT"), m_Path, sizeof(m_Path));
#else
		m_Path[0] = 0;
#endif
		xcscat_s(m_Path, elementof(m_Path), path);
	}
public:
	operator _Mylpstr	(void)			{ return m_Path; }
	operator _Mylpcstr	(void)	const	{ return m_Path; }
};

}	// end of namespace unit
}	// end of namespace iris

#endif
