﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclAudio.h
 * @brief		NaclAudio ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclAudio_H_
#define INCG_IRIS_NaclAudio_H_

//======================================================================
// include
#include "../nacl_inchead.h"
#include "../../../audio/format/AXAudioFile.h"

#if defined(IRIS_NACL)
#include <ppapi/cpp/audio.h>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	Audio クラスインターフェイス
*/
class IAudio : public pp::Audio, public IIrisObject
{
public:
	typedef pp::AudioConfig	Config;
public:
	/**
	 * @brief	コンストラクタ
	*/
	IAudio(pp::Instance* instance, const pp::AudioConfig& config)
		: pp::Audio(instance, config, Callback, this)
	{
	}

protected:
	// コールバック関数
	virtual void	OnCallback(void* sample_buffer, uint32_t buffer_size_in_bytes) = 0;

private:
	static void Callback(void* sample_buffer,
		uint32_t buffer_size_in_bytes,
		void* user_data)
	{
		IAudio* p = static_cast<IAudio*>(user_data);
		p->OnCallback(sample_buffer, buffer_size_in_bytes);
	}
};

/**
 * @ingroup	NativeClient
 * @brief	Audio クラス
*/
class CAudio : public pp::Audio, public IIrisObject
{
protected:
	ax::IAXFile*	m_pFile;	//!< ファイル
public:
	/**
	 * @brief	コンストラクタ
	*/
	CAudio(pp::Instance* instance, const pp::AudioConfig& config)
		: pp::Audio(instance, config, nullptr, this)
		, m_pFile(nullptr)
	{
	}

	/**
	 * @brief	ファイルクラスの設定
	 * @param [in]	file	= ファイルクラスポインタ
	*/
	void			SetFile(ax::IAXFile* file)	{ m_pFile = file; }

	/**
	 * @brief	ファイルクラスの取得
	 * @return ファイルクラスポインタ
	*/
	ax::IAXFile*	GetFile(void)		const	{ return m_pFile; }


public:
	/**
	 * @brief	再生
	 * @return	成否
	*/
	bool			Start(void)
	{
		return pp::Audio::StartPlayback();
	}

	/**
	 * @brief	停止
	 * @return	成否
	*/
	bool			Stop(void)
	{
		return pp::Audio::StopPlayback();
	}


protected:
	// コールバック関数
	virtual void	OnCallback(void* sample_buffer, uint32_t buffer_size_in_bytes)
	{
		if( m_pFile == nullptr ) return;
		m_pFile->ReadPCM(sample_buffer, buffer_size_in_bytes);
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
