﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclEntry.h
 * @brief		エントリ ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclEntry_H_
#define INCG_IRIS_NaclEntry_H_

//======================================================================
// include
#include "../../../fnd/container/FndSingleton.h"

#if defined(IRIS_NACL)

#include <ppapi/cpp/module.h>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	モジュールエントリクラス
*/
class IModuleEntry : public fnd::CSingleton<IModuleEntry>
{
	pp::Module*	m_pModule;
protected:
	IModuleEntry(void) : m_pModule(nullptr) {}
public:
	pp::Module*	CreateInstance(void)	{ m_pModule = OnCreateInstance(); return m_pModule; }

public:
	static pp::Module*	GetModule(void) { return IModuleEntry::GetInstance().m_pModule; }

protected:
	virtual pp::Module*	OnCreateInstance(void) { return nullptr; }
};

/**
 * @ingroup	NativeClient
 * @brief	モジュールエントリ定義クラス
 * @tparam	MODULE	= モジュールクラス
*/
template<typename MODULE>
class CModuleEntry : public IModuleEntry
{
protected:
	virtual pp::Module*	OnCreateInstance(void) { return MODULE::CreateInstance(); }
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
