﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclError.h
 * @brief		error ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclError_H_
#define INCG_IRIS_NaclError_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)
#include <ppapi/c/pp_errors.h>
#include <string>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	エラーかどうか
*/
#define NACL_FAILED(hr)		(hr < PP_OK_COMPLETIONPENDING)
#define NACL_SUCCEEDED(hr)	(hr >= PP_OK_COMPLETIONPENDING)

/**
 * @ingroup	NativeClient
 * @brief	エラーメッセージのフォーマット
*/
std::string	FormatMessage(int32_t err)
{
	switch( err )
	{
	case PP_OK: return "PP_OK";
	case PP_OK_COMPLETIONPENDING:	return "PP_OK_COMPLETIONPENDING";
	case PP_ERROR_FAILED:			return "PP_ERROR_FAILED";
	case PP_ERROR_ABORTED:			return "PP_ERROR_ABORTED";
	case PP_ERROR_BADARGUMENT:		return "PP_ERROR_BADARGUMENT";
	case PP_ERROR_BADRESOURCE:		return "PP_ERROR_BADRESOURCE";
	case PP_ERROR_NOINTERFACE:		return "PP_ERROR_NOINTERFACE";
	case PP_ERROR_NOACCESS:			return "PP_ERROR_NOACCESS";
	case PP_ERROR_NOMEMORY:			return "PP_ERROR_NOMEMORY";
	case PP_ERROR_NOSPACE:			return "PP_ERROR_NOSPACE";
	case PP_ERROR_NOQUOTA:			return "PP_ERROR_NOQUOTA";
	case PP_ERROR_INPROGRESS:		return "PP_ERROR_INPROGRESS";
	case PP_ERROR_NOTSUPPORTED:		return "PP_ERROR_NOTSUPPORTED";
	case PP_ERROR_FILEEXISTS:		return "PP_ERROR_FILEEXISTS";
	case PP_ERROR_FILETOOBIG:		return "PP_ERROR_FILETOOBIG";
	case PP_ERROR_FILECHANGED:		return "PP_ERROR_FILECHANGED";
	case PP_ERROR_TIMEDOUT:			return "PP_ERROR_TIMEDOUT";
	case PP_ERROR_USERCANCEL:		return "PP_ERROR_USERCANCEL";
	}
	return "UNKOWN";
}

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
