﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclDebug.h
 * @brief		NaclDebug ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclDebug_H_
#define INCG_IRIS_NaclDebug_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)
#include "../object/NaclVar.h"
#include "../core/NaclEntry.h"
#include <ppapi/cpp/instance.h>

namespace iris {
namespace nacl
{

//======================================================================
// function
/**
 * @ingroup	NativeClient
 * @brief	pp::Var をポスト
*/
template<typename TN>
STATICINLINE void	OutputDebugVar(TN var)
{
	pp::Module* module = IModuleEntry::GetModule();
	if( module != nullptr )
	{
		if( module->current_instances().size() )
		{
			module->current_instances().begin()->second->PostMessage(CVarHelper::Construct(var));
		}
	}
}

STATICINLINE void	printMessage(const char* fmt, ...)
{
	// FIXME: 固定長
	char buf[1024];
	va_list va;
	va_start(va, fmt);
	vsnprintf(buf, sizeof(buf), fmt, va);
	va_end(va);
	OutputDebugVar(buf);
}

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
