﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclFileSystem.h
 * @brief		NaclFileSystem ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclFileSystem_H_
#define INCG_IRIS_NaclFileSystem_H_

//======================================================================
// include
#include "../nacl_inchead.h"
#include "../../../iris_object.h"

#if defined(IRIS_NACL)

#include <ppapi/cpp/file_system.h>
#include <ppapi/cpp/completion_callback.h>

namespace iris {
namespace nacl
{

//======================================================================
// include
/**
 * @ingroup	NativeClient
 * @brief	File System クラス
*/
class CFileSystem : public pp::FileSystem, public IIrisObject
{
private:
	pp::CompletionCallback	m_Callback;
public:
	/**
	 * @breif	コンストラクタ
	 * @param [in]	instance	= インスタンスポインタ
	 * @param [in]	type		= ファイルシステムタイプ
	*/
	CFileSystem(pp::Instance* instance, PP_FileSystemType type)
		: pp::FileSystem(instance, type)
		, m_Callback(OpenCallback, this)
	{}

public:
	/**
	 * @brief	開く
	 * @param [in]	expected_size	= 許容サイズ
	*/
	int32_t Open(int64_t expected_size)
	{
		return pp::FileSystem::Open(expected_size, m_Callback);
	}

protected:
	/**
	 * @brief	コールバック関数
	 * @param [in]	result	= 結果
	*/
	virtual void	OnOpen(int32_t result)
	{
		IRIS_UNUSED_VAR(result);
		OutputDebugVar(FormatMessage(result));
	}

public:
	// callback 関数
	static void	OpenCallback(void* user_data, int32_t result)
	{
		CFileSystem* fs = static_cast<CFileSystem*>(user_data);
		fs->OnOpen(result);
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
