﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclMethod.h
 * @brief		Methodect ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclMethod_H_
#define INCG_IRIS_NaclMethod_H_

//======================================================================
// include
#include "../nacl_inchead.h"
#include "../../../fnd/container/smart_ptr/FndRefPtr.h"

#if defined(IRIS_NACL)

#include "NaclDelegator.h"

namespace iris {
namespace nacl
{

//======================================================================
// declare
class IMethod;

//======================================================================
// typedef
typedef fnd::CRefPtr<IMethod>	Method;

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	メソッド インターフェイスクラス
*/
class IMethod : public IIrisObject
{
public:
	virtual ~IMethod(void) {}
public:
	virtual pp::Var	Invoke(const std::vector<pp::Var>& args) = 0;
};

/**
 * @ingroup	NativeClient
 * @brief	メソッド定義 クラス
*/
template<typename Function>
class CMethod : public IMethod
{
protected:
	Function	m_func;
public:
	/// コンストラクタ
	CMethod(Function func) : m_func(func) {}

	/// 実行
	virtual pp::Var	Invoke(const std::vector<pp::Var>& args)
	{
		return CDelegator<Function>::Delegate(m_func, args);
	}
};

/**
 * @ingroup	NativeClient
 * @brief	メンバーメソッド定義 クラス
*/
template<class TC, typename Function>
class CMemberMethod : public IMethod
{
protected:
	TC*			m_obj;
	Function	m_func;
public:
	/// コンストラクタ
	CMemberMethod(TC* obj, Function func) : m_obj(obj), m_func(func) {}

	/// 実行
	virtual pp::Var	Invoke(const std::vector<pp::Var>& args)
	{
		return CDelegator<Function>::Delegate(m_obj, m_func, args);
	}
};

/**
 * @ingroup	NativeClient
 * @brief	メンバーメソッド生成 クラス
*/
class CMethodFactory : public IIrisObject
{
public:
	template<typename Function>
	static Method	CreateMethod(Function func)
	{
		IMethod* ref = new CMethod<Function>(func);
		return ref;
	}
	/// メソッド作成
	template<class TC, typename Function>
	static Method	CreateMethod(TC* p, Function func)
	{
		IMethod* ref = new CMemberMethod<TC, Function>(p, func);
		return ref;
	}
};


}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
