//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		xf_iostream.h
 * @brief		iostreamT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_xf_iostream_H_
#define INCG_IRIS_xf_iostream_H_

//======================================================================
// include
#include "../iris_iostream.h"
#include "xf_types.h"

#if defined(__cplusplus)

#ifndef _IRIS_NOT_SUPPORT_IOSTREAM

//======================================================================
// define
// ֐`}N
#define IOSTREAM_FUNC_DEC_MBS(strm, op, type)	std::strm& operator op (std::strm&, const type&)
#if	IRIS_WCS
#  define IOSTREAM_FUNC_DEC_WCS(strm, op, type)	IOSTREAM_FUNC_DEC_MBS(w##strm, op, type)
#else
#  define IOSTREAM_FUNC_DEC_WCS(strm, op, type)	(void)0
#endif
#define IOSTREAM_FUNC_DEC(strm, op, type)		IOSTREAM_FUNC_DEC_WCS(strm, op, type); IOSTREAM_FUNC_DEC_MBS(strm, op, type)

//======================================================================
// function
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFRect);

IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec2);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec3);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFVec4);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx22);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx33);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx43);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFMtx44);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFPlane);

IOSTREAM_FUNC_DEC(ostream, <<, IrisXFColor);

IOSTREAM_FUNC_DEC(ostream, <<, IrisXFCMY);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFCMYK);
IOSTREAM_FUNC_DEC(ostream, <<, IrisXFHSV);

IOSTREAM_FUNC_DEC(ostream, <<, IrisXFComplex);

IOSTREAM_FUNC_DEC(ostream, <<, IrisXFInt);

#undef IOSTREAM_FUNC_DEC_MBS
#undef IOSTREAM_FUNC_DEC_WCS
#undef IOSTREAM_FUNC_DEC

#endif

#endif	// #if defined(__cplusplus)

#endif
