@echo off

pushd "%~dp0"
SET TARGETPATH=%~dp0/../../src

SET VCINSTALLDIR=%ProgramFiles(x86)%\Microsoft Visual Studio 9.0\VC

call :set_inc

SET INC=-I %~dp0/../../src %INC%
SET DEFS=-D__cplusplus -DWIN32 -D_WIN32 -D_NDEBUG -D_WINDOWS -D_MSC_VER=1500 -DUCHAR_MAX=0xFF -DUSHRT_MAX=0xFFFF
SET DEFS=%DEFS% -DULONG_MAX=0xFFFFFFFF
rem SET UNDEFS=-U_IRIS_DEBUGTEST_ENABLE -U_IRIS_MULTI_UNITTEST -U_IRIS_SUPPORT_MULTI_UNITTEST_GUI -U_IRIS_FPU_INLINE
rem SET UNDEFS=%UNDEFS% -U_IRIS_XFPU_INLINE -U_IRIS_DX_RIGHTHAND -U_IRIS_SUPPORT_SAFE_ISTREAM -U_IRIS_SUPPORT_DCAST_DYNAMIC
rem SET UNDEFS=%UNDEFS% -U_IRIS_SUPPORT_OPENAL -U_IRIS_SUPPORT_OGGVORBIS -U_IRIS_SUPPORT_GLUT -U_IRIS_SUPPORT_GLEW
rem SET UNDEFS=%UNDEFS% -U_IRIS_SUPPORT_GLEXT -U_IRIS_SUPPORT_CG -U_IRIS_SUPPORT_FBX -U_IRIS_SUPPORT_PNG -U_IRIS_SUPPORT_SQUIRREL
rem SET UNDEFS=%UNDEFS% -U_IRIS_SUPPORT_GOOGLETEST -U_IRIS_SUPPORT_MSXML -U_IRIS_SUPPORT_OPENCV=IRIS_DYNAMIC_LIB -U_IRIS_SUPPORT_WDK
rem SET UNDEFS=%UNDEFS% -U_IRIS_SUPPORT_LUA -U_IRIS_SUPPORT_ANGELSCRIPT
SET SUPPRESS=--inline-suppr
rem SET CHECKCONFING=--check-config
SET BUILDOPTIONS=%DEFS% %UNDEFS% %CHECKCONFING% --platform=win32A %INC% %EXCLUDE%
SET OPTIONS=--template vs -f --std=c99 --enable=style %SUPPRESS% %BUILDOPTIONS%
rem SET OPTIONS=--template vs --enable=all
rem SET OPTIONS=

rem gp֐`FbNȂꍇ͂
rem call cppcheck --enable=exceptNew --enable=exceptRealloc --enable=style -j %NUMBER_OF_PROCESSORS% "%TARGETPATH%" 
rem call cppcheck --enable=exceptNew --enable=exceptRealloc --enable=style "%TARGETPATH%" 

rem Sꍇ͂
@echo %OPTIONS%
cd "%TARGETPATH%"
call cppcheck %OPTIONS% -v --xml --report-progress ./ 2> "%~dp0\result.xml"
if errorlevel 1 goto error
popd

call add_xsl.bat result.xml
if errorlevel 1 goto error

del /F /Q result.xml.org
if errorlevel 1 goto error

goto end

:error
pause
popd
exit /b 1

:end
popd
exit /b 0


:set_inc
for /f "delims=;" %%a in ("%INCLUDE%") do call :add_inc "%%a"
goto :EOF

:add_inc
SET ARG=%~1
if "%ARG:~-1%" == "\" (
	SET INC=%INC% -I "%ARG:~0,-1%"
	SET EXCLUDE=%EXCLUDE% -i"%ARG:~0,-1%"
) else (
	SET INC=%INC% -I "%ARG%"
	SET EXCLUDE=%EXCLUDE% -i"%ARG%"
)
goto :EOF
