//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		main.cpp
 * @brief		main t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_main_CPP_

//======================================================================
// include
#include "iris_main.h"
#include "win/resource/WXVersionInfo.h"
#include "win/os/environment/WXOSVersion.h"
#include "win/shell/WXCSIDL.h"
#include "win/exp/registry/WXInstallRegistry.h"
#include "fnd/io/FndFile.h"
#include "win/shell/WXShellPath.h"
#include "fnd/container/FndRegexOp.h"
#include "iris_using.h"

#include <tchar.h>
#include <shlwapi.h>
#include <shlobj.h>

//======================================================================
// link
#pragma comment (lib, "shlwapi.lib")

//======================================================================
// define
#define COMMENT \
"//======================================================================" NL\
"//-----------------------------------------------------------------------" NL\
"/**" NL\
" * @file		%s.%s" NL\
" * @brief		prefix t@C" NL\
" *" NL\
" * @author		%s" NL\
" * @version		%s" NL\
"*/" NL\
"//-----------------------------------------------------------------------" NL\
"//======================================================================" NL\
"#ifndef _FILE_%s_%s_" NL \
"#define _FILE_%s_%s_" NL \
NL

#define COMMENT_ARG(name, ext, exe, ver)	name, ext, exe, ver, name, ext, name, ext

#define NL	"\r\n"

#define END \
NL\
"#endif" NL

#define WINNT \
"#ifndef _WIN32_WINNT" NL			\
"#define _WIN32_WINNT	0x%.4x" NL	\
"#endif" NL							\
NL

#define DEFINE(def)	""\
"#ifndef " #def NL \
"#  define " #def NL \
"#endif" NL


#define DEFPARAM(def, param)	\
"#ifndef " #def NL \
"#  define " #def "\t" #param NL \
"#endif" NL

#define WRITE_NL()		file.Write(NL, _tcslen(NL), 1)



int iris_main(void)
{
	TCHAR out_path[MAX_PATH] = IRIS_TEXT("./prefix.h");
	TCHAR buf[4096];
	u32 winnt_ver = 0;
	for( int i=1; i < ::__argc; ++i )
	{
		if( ::__targv[i][0] == '-' && ::__targv[i][1] != '\0' && ::__targv[i][2] == '\0' )
		{
			switch( ::__targv[i][1] )
			{
			case 'o':
				_tcscpy_s(out_path, MAX_PATH, ::__targv[++i]);
				break;
			case 'h':
				goto help;
			case 'w':
				++i;
				if( i < ::__argc )
				{
					if( _tcsicmp(__targv[i], IRIS_TEXT("xp")) == 0 )
					{
						winnt_ver = 0x0501;
					}
					else if( _tcsicmp(__targv[i], IRIS_TEXT("vista")) == 0 )
					{
						winnt_ver = 0x0600;
					}
					else if( _tcsicmp(__targv[i], IRIS_TEXT("7")) == 0 )
					{
						winnt_ver = 0x0601;
					}
				}
				break;
			default:
				break;
			}
		}
	}

file_open:
	{
		bool glut = false;
		
		CVersionInfo vi;
		if( !vi.Open() ) return 1;

		CFile file;
		if( !file.Open(out_path, IRIS_TEXT("wb")) ) return 1;
		printf("Create %s\n", out_path);

		TCHAR* fname = PathFindFileName(out_path);
		TCHAR* ext = PathFindExtension(fname);
		if( ext != nullptr ) *ext++ = '\0';
		TCHAR* exename;
		TCHAR* version;
		vi.GetOriginalFileName(&exename);
		vi.GetFileVersion(&version);
		wsprintf(buf, IRIS_TEXT(COMMENT), COMMENT_ARG(fname, ext, exename, version));
		file.Write(buf, _tcslen(buf), 1);

		// WINVER
		if( winnt_ver == 0 )
		{
			COSVersionInfo osvi;
			if( osvi.IsValid() )
			{
				winnt_ver = (osvi->dwMajorVersion << 8) | (osvi->dwMinorVersion);
			}
		}
		
		if( winnt_ver != 0 )
		{
			wsprintf(buf, WINNT, winnt_ver);
			file.Write(buf, _tcslen(buf), 1);
			puts("_WIN32_WINNT");
		}

		// Windows Driver Kit
		{
			cpp0x::tr1::regex reg("Microsoft Windows Driver Kit");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_WDK));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_WDK");
			}
		}


		CCSIDLPath pgdir(CSIDL_PROGRAM_FILES);
		CPath path;
		TCHAR env[MAX_PATH];
		// Cg
		{
			if( GetEnvironmentVariable(IRIS_TEXT("CG_INC_PATH"), env, sizeof(env)) != 0 )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_CG));
				file.Write(buf, _tcslen(buf), 1);
				// glut 
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_GLUT));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_CG");
				puts("_IRIS_SUPPORT_GLUT");
				glut = true;
			}
		}
		// fbx
		{
			cpp0x::tr1::regex reg("Autodesk FBX SDK [0-9].*");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_FBX, IRIS_DEFAULT_LIB));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_FBX");
			}
		}
		// OpenAL 1.1
		{
			cpp0x::tr1::regex reg("OpenAL [0-9].*?.[0-9].*? Core PC SDK");
			if( CInstallRegistry::IsInstall(CRegexSearchOp<>(), reg) )
			{
				wsprintf(buf, DEFINE(_IRIS_SUPPORT_OPENAL));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_SUPPORT_OPENAL");
			}
		}

		// IRIS_ROOT
		{
			CPath iris_root;
			if( iris_root.ExpandEnvStrings(IRIS_TEXT("%IRIS_ROOT%")) && iris_root.IsDirectory() )
			{
				if( iris_root.Append(IRIS_TEXT("iris\\external\\windows\\include")) )
				{
					iris_root.AddBackslash();

					// glut
					if( !glut && CPath::FileExists(iris_root + IRIS_TEXT("gl\\glut.h")) )
					{
						wsprintf(buf, DEFINE(_IRIS_SUPPORT_GLUT));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_GLUT");
						glut = true;
					}

					// glew
					if( CPath::FileExists(iris_root + IRIS_TEXT("gl\\glew.h")) )
					{
						wsprintf(buf, DEFINE(_IRIS_SUPPORT_GLEW));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_GLEW");
					}

					// Ogg Vorbis
					if( CPath::FileExists(iris_root + IRIS_TEXT("ogg\\ogg.h")) 
						&& CPath::FileExists(iris_root + IRIS_TEXT("vorbis\\vorbisfile.h")) )
					{
						wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_OGGVORBIS, IRIS_DEFAULT_LIB));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_OGGVORBIS");
					}

					// png
					if( CPath::FileExists(iris_root + IRIS_TEXT("png.h")) )
					{
						wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_PNG, IRIS_DEFAULT_LIB));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_PNG");
					}

					// lua
					if( CPath::FileExists(iris_root + IRIS_TEXT("lua.hpp")) )
					{
						wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_LUA, IRIS_DEFAULT_LIB));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_LUA");
					}

					// squirrel
					if( CPath::FileExists(iris_root + IRIS_TEXT("squirrel.h")) )
					{
						wsprintf(buf, DEFINE(_IRIS_SUPPORT_SQUIRREL));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_SQUIRREL");
					}

					// OpenCV
					if( CPath::FileExists(iris_root + IRIS_TEXT("opencv\\cv.h")) )
					{
						wsprintf(buf, DEFPARAM(_IRIS_SUPPORT_OPENCV, IRIS_DEFAULT_LIB));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_OPENCV");
					}

					// MSXML
					if( CPath::FileExists(iris_root + IRIS_TEXT("msxml3.tlh")) )
					{
						wsprintf(buf, DEFINE(_IRIS_SUPPORT_MSXML));
						file.Write(buf, _tcslen(buf), 1);
						puts("_IRIS_SUPPORT_MSXML");
					}

				}
			}
		}

		WRITE_NL();

		// HTML HELP WORKSHOP
		{
			if( CInstallRegistry::IsInstall(IRIS_TEXT("HTML Help Workshop")) )
			{
				wsprintf(buf, DEFINE(_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP));
				file.Write(buf, _tcslen(buf), 1);
				puts("_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP");
			}
			else
			{
				path = pgdir;
				path.AddFileName("HTML Help Workshop\\include");
				if( path.FileExists() )
				{
					wsprintf(buf, DEFINE(_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP));
					file.Write(buf, _tcslen(buf), 1);
					puts("_IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP");
				}
			}
		}

		WRITE_NL();
		WRITE_NL();

		// user define
		for( int i=1; i+1 < ::__argc; ++i )
		{
			if( ::__argv[i][0] == '-' && ::__argv[i][1] != '\0' && ::__argv[i][2] == '\0' )
			{
				switch( ::__argv[i][1] )
				{
				case 'D':
					{
						TCHAR n[512];
						LPTSTR cur;
						_tcscpy_s(n, IRIS_NumOfElements(n), ::__argv[++i]);
						LPTSTR p = _tcstok_s(n, "=", &cur);
						if( p == nullptr )
						{
							wsprintf(buf, "#define %s	", n);
						}
						else
						{
							LPTSTR v = _tcstok_s(nullptr, "=", &cur);
							wsprintf(buf, "#define %s	%s", p, v);
						}
						file.Write(buf, _tcslen(buf), 1);
					}
					break;
				}
			}
		}

		wsprintf(buf, IRIS_TEXT(END));
		file.Write(buf, _tcslen(buf), 1);

		return 0;
	}

help:
	{
		puts("iris_prefix_optimize help");
		puts("-h        : show help.");
		puts("-o [path] : output path set.");
		puts("-D [def=v]: user define set. def = name, v = value.");
		puts("            \'v\' can be omitted. ");
	}
	return 0;
}
