# œK̐ݒ
ifdef DEBUG
  MODE		:= Debug
  POSTFIX	:= d
  DEF		+= _DEBUG USE_UART
  OPTIMIZE	:= -O0  
else
  MODE		:= Release
  POSTFIX	:=
  DEF		+= NDEBUG
  OPTIMIZE	:= -Os  -finline-functions
endif

OBJDIR_BASE	:= .obj
OBJDIR		:= $(OBJDIR_BASE)/$(MODE)
ifdef INSTALL_DIR
INSTALL_LIBDIR := $(INSTALL_DIR)lib/$(MODE)
else
INSTALL_LIBDIR	:= $(ROOT)lib/$(MODE)
endif
DEPENDFILE	:= $(OBJDIR)/.depend
MAPFILE		:= $(TARGET_NAME).map

ifeq ($(TARGET_MODE),APP)
  TARGET_ELF	:= $(TARGET_NAME).elf
  TARGET_BIN	:= $(TARGET_NAME).bin
  TARGET_HEX	:= $(TARGET_NAME).hex
  TARGET_S19	:= $(TARGET_NAME).s19
  USE_DEPEND	:= 1
endif

ifeq ($(TARGET_MODE),LIB)
  TARGET_LIB	:= lib$(TARGET_NAME)$(POSTFIX).a
  USE_DEPEND	:= 1
endif

# arm-stm32-elfc[
ifeq ($(TOOLCHAIN), SOURCEY)
TOOL		:= "C:/Program Files/CodeSourcery/Sourcery G++ Lite/bin/arm-none-eabi"
else
TOOL		:= /usr/local/bin/arm-stm32-elf
endif

AS			:= $(TOOL)-as
CC			:= $(TOOL)-gcc
LD			:= $(TOOL)-ld
OBJCOPY		:= $(TOOL)-objcopy
OBJDUMP		:= $(TOOL)-objdump
AR			:= $(TOOL)-ar

# ėp`
PERL		:= perl
DEF			+= STM32
DEFINE_AS	:= $(DEF:%=--defsym %=1)
DEFINE_C	:= $(DEF:%=-D%)
INCLUDE_C	:= $(INC:%=-I%)
LINK_LIB	:= $(LNK:%=-l%$(POSTFIX))
ASFLAGS		+= $(DEFINE_AS) -mthumb -gstabs -warn
CFLAGS		+= $(DEFINE_C) -g -Wall -mcpu=cortex-m3 -mthumb -mlittle-endian --no-builtin $(OPTIMIZE) $(INCLUDE_C) 
LDFLAGS		+= -g -Map $(MAPFILE) -nostartfiles -nostdlib -L$(INSTALL_LIBDIR) $(LINK_LIB)
DISAS		:= $(OBJDUMP) -t -S 
AND			:= &&
SRCNDIR		:= $(notdir $(SRC))
OBJS		:= 	$(SRC_S:%.s=$(OBJDIR)/%.o) $(SRCNDIR:%.c=$(OBJDIR)/%.o)

define	MKTMP
			if [ ! -d $(@D) ]; then \
			  echo "o̓tH_܂... $(@D)"; \
			  mkdir -p $(@D); \
			fi
endef
define	COMPILE
			@$(MKTMP)
			@echo Compiling ... $<  
			$(CC) $(CFLAGS) -c $< -o $@ 
endef
define	COMPILE_S
			@$(MKTMP)
			@echo Compiling ... $<  
			$(AS) $(ASFLAGS) $< -o $@ 
endef


.PHONY: .subdir .target clean depend rebuild dump

main: 
ifdef SUBDIR
	$(foreach d, $(SUBDIR),make -C $d $@ $(AND)) true;
endif
	make .target

clean:
ifdef SUBDIR
	@$(foreach d, $(SUBDIR),make -C $d $@ $(AND)) true;
endif
	rm -f *~
	rm -rf $(OBJDIR_BASE)
	rm -rf $(MAPFILE)
ifdef TARGET_ELF
	rm -rf $(TARGET_ELF)
	rm -rf $(TARGET_BIN)
	rm -rf $(basename $(TARGET_ELF)).dis
endif
ifdef TARGET_LIB
	rm -rf $(TARGET_LIB)
endif

.target: $(TARGET_ELF) $(TARGET_LIB)
ifdef TARGET_MODE
endif

ifdef TARGET_ELF

ifdef LDSCRIPT
$(TARGET_ELF):	$(OBJS) $(MAKEFILE) $(LDSCRIPT) $(LIBS)
	@echo Nł ... $@
	$(LD) --start-group $(OBJS) $(LDFLAGS) -o $(TARGET_ELF) $(LIBS) -T $(LDSCRIPT) --end-group
ifdef OUTPUT_BINARY
	$(OBJCOPY) -O binary $(TARGET_ELF) $(TARGET_BIN) 
endif
ifdef OUTPUT_HEX
	$(OBJCOPY) -O ihex $(TARGET_ELF) $(TARGET_HEX) 
endif
ifdef OUTPUT_S19
	$(OBJCOPY) -O srec $(TARGET_ELF) $(TARGET_S19) 
endif
ifdef OUTPUT_OBJDUMP
	$(OBJDUMP) -S $(TARGET_ELF) >> $(TARGET_NAME).txt
endif

else
$(TARGET_ELF):	$(OBJS) $(MAKEFILE) $(LIBS)
	@echo Nł ... $@
	$(LD) --start-group $(OBJS) $(LDFLAGS) -o $(TARGET_ELF) $(LIBS) --end-group
ifdef OUTPUT_BINARY
	$(OBJCOPY) -O binary $(TARGET_ELF) $(TARGET_BIN) 
endif
ifdef OUTPUT_HEX
	$(OBJCOPY) -O ihex $(TARGET_ELF) $(TARGET_HEX) 
endif
ifdef OUTPUT_S19
	$(OBJCOPY) -O srec $(TARGET_ELF) $(TARGET_S19) 
endif
ifdef OUTPUT_OBJDUMP
	$(OBJDUMP) -S $(TARGET_ELF) >> $(TARGET_NAME).txt
endif
endif

endif

ifdef TARGET_LIB

## Curh

$(TARGET_LIB): $(OBJS) 
	@echo A[JCuł ... $@
	@-rm -f $(TARGET_LIB)
	@$(AR) -q $(TARGET_LIB) $(OBJS)
ifdef INSTALL
	@mkdir -p $(INSTALL_LIBDIR)
	cp $(TARGET_LIB) $(INSTALL_LIBDIR)/.
endif

endif

ifeq ($(USE_DEPEND), 1)

## ˑ֌W

depend:: $(DEPENDFILE)

OBJDIR_S = $(subst /,\/,$(OBJDIR))
SRC_SX = $(subst .S,.@S,$(SRC_S))

$(DEPENDFILE)::	$(MAKEFILE) Makefile $(ROOT)/Makefile.def $(SRC) $(SRC_S)
	@echo ˑ֌W\zĂ܂ ...
	@$(MKTMP)
	@-rm -f $(DEPENDFILE)
ifdef	SRC
	@$(CC) $(CFLAGS) -MM $(SRC) > $(DEPENDFILE).tmp
	@cat $(DEPENDFILE).tmp | sed -e "s/^.*\\.o/$(OBJDIR_S)\\/\\0/" | sed -e "s/\([^\\]\)$$/\\1@	$$\(COMPILE\)@/g" | tr @ \\n >> $(DEPENDFILE)
endif
ifdef	SRC_S
	@echo $(SRC_S) | sed -e "s/\/*\([^.]*\)\.[s,S]/$(OBJDIR_S)\\/\\1\.o: \\1\.s\\n	$$\(COMPILE_S\)\n/g" >> $(DEPENDFILE)
endif

endif


## rhR}h
rebuild : clean main

## dump
dump:
	$(OBJDUMP) -S $(TARGET_ELF) >> $(TARGET_NAME).txt


