//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALPlayer.cpp
 * @brief		OpenAL vC[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALPlayer_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "AXALPlayer.h"
#if		defined(_WIN32)
#include <al.h>
#elif	(defined(TARGET_OS_MAC) && TARGET_OS_MAC)
#include <OpenAL/al.h>
#endif
#include "AXALBuffer.h"
#include "AXALError.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALPlayer::CALPlayer(void)
: m_Source(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CALPlayer::~CALPlayer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CALPlayer::Initialize(void)
{
	alGenSources(1, &m_Source);
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CALPlayer::Release(void)
{
	AXALS32 n;
	geti(AL_BUFFERS_PROCESSED, &n);
	for( int i=0; i < n; ++i )
	{
		AXALU32 buffer;
		alSourceUnqueueBuffers(m_Source, 1, &buffer);
	}
	// delete spurce list
	alDeleteSources(1, &m_Source);
}

/**********************************************************************//**
 *
 * obt@̓o^
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::StreamOut(CALBuffer* pBuffer, AXALBOOL isQueue)
{
	if( isQueue )
	{
		Enqueue(pBuffer);
	}
	else
	{
		SetBuffer(pBuffer);
	}
	return false;
}

/**********************************************************************//**
 *
 * obt@̓o^
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::SetBuffer(CALBuffer* pBuffer)
{
	AXALENUM err_code;
	alGetError();

	if( pBuffer != nullptr )
	{
		AXALU32 buffer = pBuffer->GetBuffer();
		AXALS32 join_buf;
		geti(AL_BUFFER, &join_buf);
		err_code = alGetError();
		if( (err_code == AL_NO_ERROR) && join_buf != buffer )
		{
			seti(AL_BUFFER, buffer);
			DetachObserverAll();
			AttachObserver(pBuffer);
		}
	}
	else
	{
		seti(AL_BUFFER, AL_NONE);
		DetachObserverAll();
	}
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	return true;
}

/**********************************************************************//**
 *
 * GL[
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::Enqueue(CALBuffer* pBuffer)
{
	alGetError();

	if( pBuffer != nullptr )
	{
		AXALU32 buffer = pBuffer->GetBuffer();
		if( buffer == 0 ) return false;
		alSourceQueueBuffers(m_Source, 1, &buffer);
		AXAL_DO_CHECK_RESULT(alGetError(), return false);
		AttachObserver(pBuffer);
		return true;
	}

	seti(AL_BUFFER, AL_NONE);
	DetachObserverAll();
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	return true;
}

/**********************************************************************//**
 *
 * fL[
 *
 ----------------------------------------------------------------------
 * @param [in]	num			= fL[鐔
 * @param [out]	lpBuffers	= fL[obt@̊i[AhX
 * @return 
*//***********************************************************************/
bool CALPlayer::Dequeue(AXALSIZEI num, AXALU32* lpBuffers)
{
	if( lpBuffers == nullptr ) return false;
	alSourceUnqueueBuffers(m_Source, num, lpBuffers);
	for( AXALSIZEI i=0; i < num; ++i )
	{
		CALBuffer* buffer = GetObserver();
		while(1)
		{
			if( buffer == nullptr ) return false;
			if( buffer->GetBuffer() == lpBuffers[i] )
			{
				DetachObserver(buffer);
				break;
			}
			buffer = buffer->GetNext();
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * fL[
 *
 ----------------------------------------------------------------------
 * @param [in]	num			= fL[鐔
 * @param [out]	lpBuffers	= fL[obt@̊i[AhX
 * @return 
*//***********************************************************************/
bool CALPlayer::Dequeue(AXALSIZEI num)
{
	for( AXALSIZEI i=0; i < num; ++i )
	{
		AXALU32 dequeue_buffer;
		alSourceUnqueueBuffers(m_Source, 1, &dequeue_buffer);
		CALBuffer* buffer = GetObserver();
		while(1)
		{
			if( buffer == nullptr ) return false;
			if( buffer->GetBuffer() == dequeue_buffer )
			{
				DetachObserver(buffer);
				break;
			}
			buffer = buffer->GetNext();
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * Đ̊Jn(Đ͂ȂɂȂ)
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::Play(void)
{
	IRIS_ASSERT( IsValid() );
	if( !IsPlay() )
	{
		alGetError();
		alSourcePlay(m_Source);
		AXAL_DO_CHECK_RESULT(alGetError(), return false);
	}
	return true;
}

/**********************************************************************//**
 *
 * 擪Đ̊Jn
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::Replay(void)
{
	IRIS_ASSERT( IsValid() );
	alGetError();
	alSourcePlay(m_Source);
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	return true;
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::Stop(void)
{
	alGetError();
	alSourceStop(m_Source);
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	seti(AL_BUFFER, AL_NONE);
	DetachObserverAll();
	return true;
}

/**********************************************************************//**
 *
 * ꎞ~
 *
*//***********************************************************************/
void CALPlayer::Pause(void)
{
	AXALS32 state;
	geti(AL_SOURCE_STATE, &state);
	if( state == AL_PLAYING )
	{
		alSourcePause(m_Source);
	}
}

/**********************************************************************//**
 *
 * ĊJ
 *
*//***********************************************************************/
void CALPlayer::Continue(void)
{
	AXALS32 state;
	geti(AL_SOURCE_STATE, &state);
	if( state == AL_PAUSED )
	{
		IRIS_ASSERT( IsValid() );
		alSourcePlay(m_Source);
	}
}

/**********************************************************************//**
 *
 * ItZbgn_ɖ߂
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool CALPlayer::Rewind(void)
{
	alGetError();
	alSourceRewind(m_Source);
	AXAL_DO_CHECK_RESULT(alGetError(), return false);
	return true;
}

/**********************************************************************//**
 *
 * Đǂ
 *
 ----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CALPlayer::IsPlay(void)	const
{
	AXALS32 state;
	geti(AL_SOURCE_STATE, &state);
	return (state == AL_PLAYING);
}

/**********************************************************************//**
 *
 * {[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	isMute	= ~[gݒ
*//***********************************************************************/
void CALPlayer::Mute(AXALBOOL isMute)
{
	if( isMute )
	{
		setf(AL_MAX_GAIN, 0.f);
	}
	else
	{
		setf(AL_MAX_GAIN, 1.f);
	}
}

/**********************************************************************//**
 *
 * Đʒuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= xʒu
 * @param [in]	y	= yʒu
 * @param [in]	z	= zʒu
*//***********************************************************************/
void CALPlayer::SetPosition(AXALF32 x, AXALF32 y, AXALF32 z)
{
	set3f(AL_POSITION, x, y, z);
}

/**********************************************************************//**
 *
 * {[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	volume	= {[(0`4096)
*//***********************************************************************/
void CALPlayer::SetVolume(AXALS32 volume)
{
	SetVolumeF((AXALF32)volume / VOLUME_MAX);
}

/**********************************************************************//**
 *
 * {[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	volume	= {[(0.f`2.f)
*//***********************************************************************/
void CALPlayer::SetVolumeF(AXALF32 volume)
{
	setf(AL_GAIN, volume);
}

/**********************************************************************//**
 *
 * [vݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	isLoop	= [vݒ
*//***********************************************************************/
void CALPlayer::SetLoop(AXALBOOL isLoop)
{
	seti(AL_LOOPING, isLoop);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	distance	= (0.0f~any)
*//***********************************************************************/
void CALPlayer::SetReferenceDistance(AXALF32 distance)
{
	setf(AL_REFERENCE_DISTANCE, distance);
}

/**********************************************************************//**
 *
 * ̍őlݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	distance	= (0.0f~any)
*//***********************************************************************/
void CALPlayer::SetMaxDistance(AXALF32 distance)
{
	setf(AL_MAX_DISTANCE, distance);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	rolloff	= (0.0f~any)
*//***********************************************************************/
void CALPlayer::SetRolloffFactor(AXALF32 rolloff)
{
	setf(AL_ROLLOFF_FACTOR, rolloff);
}

/**********************************************************************//**
 *
 * sb`̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pitch	= sb`(0.0f~any)
*//***********************************************************************/
void CALPlayer::SetPitch(AXALF32 pitch)
{
	setf(AL_PITCH, pitch);
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= x
 * @param [in]	y	= y
 * @param [in]	z	= z
*//***********************************************************************/
void CALPlayer::SetDirection(AXALF32 x, AXALF32 y, AXALF32 z)
{
	set3f(AL_DIRECTION, x, y, z);
}

/**********************************************************************//**
 *
 * R[̓p̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	angle	= p
*//***********************************************************************/
void CALPlayer::SetCornInnerAngle(AXALF32 angle)
{
	setf(AL_CONE_INNER_ANGLE, angle);
}

/**********************************************************************//**
 *
 * R[̊Op̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	angle	= Op
*//***********************************************************************/
void CALPlayer::SetCornOuterAngle(AXALF32 angle)
{
	setf(AL_CONE_OUTER_ANGLE, angle);
}

/**********************************************************************//**
 *
 * R[̊Op̃QCݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	gain	= Op̃QC
*//***********************************************************************/
void CALPlayer::SetCornOuterGain(AXALF32 gain)
{
	setf(AL_CONE_OUTER_GAIN, gain);
}

/**********************************************************************//**
 *
 * Đʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	sec	= ĐʒuibPʁj
*//***********************************************************************/
void CALPlayer::SetOffsetSec(AXALF32 sec)
{
	setf(AL_SEC_OFFSET, sec);
}

/**********************************************************************//**
 *
 * Đʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	sample	= ĐʒuiTvPʁj
*//***********************************************************************/
void CALPlayer::SetOffsetSample(AXALF32 sample)
{
	setf(AL_SAMPLE_OFFSET, sample);
}

/**********************************************************************//**
 *
 * Đʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	sample	= ĐʒuioCgPʁj
*//***********************************************************************/
void CALPlayer::SetOffsetByte(AXALF32 byte)
{
	setf(AL_BYTE_OFFSET, byte);
}

/**********************************************************************//**
 *
 * Έʒuǂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	relative	= Έʒuǂ
*//***********************************************************************/
void CALPlayer::SetSourceRelative(AXALBOOL relative)
{
	setf(AL_SOURCE_RELATIVE, relative);
}

/**********************************************************************//**
 *
 * L[̐擾
 *
 ----------------------------------------------------------------------
 * @return L[̐
*//***********************************************************************/
AXALS32 CALPlayer::GetQueueBufferNum(void)	const
{
	AXALS32 num;
	geti(AL_BUFFERS_QUEUED, &num);
	return num;
}

/**********************************************************************//**
 *
 * Đς݃L[̐擾
 *
 ----------------------------------------------------------------------
 * @return Đς݃L[̐
*//***********************************************************************/
AXALS32 CALPlayer::GetProcessedBufferNum(void)	const
{
	AXALS32 num;
	geti(AL_BUFFERS_PROCESSED, &num);
	return num;
}

/**********************************************************************//**
 *
 * \[X񋟂łGAIN̍ŏl擾
 *
 ----------------------------------------------------------------------
 * @return GAIN̍ŏl
*//***********************************************************************/
AXALF32 CALPlayer::GetMinGain(void)	const
{
	AXALF32 gain;
	getf(AL_MIN_GAIN, &gain);
	return gain;
}

/**********************************************************************//**
 *
 * \[X񋟂łGAIN̍ől擾
 *
 ----------------------------------------------------------------------
 * @return GAIN̍ŏl
*//***********************************************************************/
AXALF32 CALPlayer::GetMaxGain(void)	const
{
	AXALF32 gain;
	getf(AL_MAX_GAIN, &gain);
	return gain;
}

/**********************************************************************//**
 *
 * Lȃ\[XIuWFNgǂ
 *
 ----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CALPlayer::IsValid(void)	const
{
	return (alIsSource(m_Source) != 0);
}

// wrap

/**********************************************************************//**
 *
 * alSourcei
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	value	= l
*//***********************************************************************/
void CALPlayer::seti(AXALENUM param, AXALS32 value)
{
	alSourcei(m_Source, param, value);
}

/**********************************************************************//**
 *
 * alSourcef
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	value	= l
*//***********************************************************************/
void CALPlayer::setf(AXALENUM param, AXALF32 value)
{
	alSourcef(m_Source, param, value);
}

/**********************************************************************//**
 *
 * alSource3i
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	v1		= l
 * @param [in]	v2		= l
 * @param [in]	v3		= l
*//***********************************************************************/
void CALPlayer::set3i(AXALENUM param, AXALS32 v1, AXALS32 v2, AXALS32 v3)
{
	alSource3i(m_Source, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alSource3f
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	v1		= l
 * @param [in]	v2		= l
 * @param [in]	v3		= l
*//***********************************************************************/
void CALPlayer::set3f(AXALENUM param, AXALF32 v1, AXALF32 v2, AXALF32 v3)
{
	alSource3f(m_Source, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alSourceiv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	values	= lz
*//***********************************************************************/
void CALPlayer::setiv(AXALENUM param, const AXALS32* values)
{
	alSourceiv(m_Source, param, values);
}

/**********************************************************************//**
 *
 * alSourcefv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [in]	values	= lz
*//***********************************************************************/
void CALPlayer::setfv(AXALENUM param, const AXALF32* values)
{
	alSourcefv(m_Source, param, values);
}

/**********************************************************************//**
 *
 * alGetSourcei
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	value	= l
*//***********************************************************************/
void CALPlayer::geti(AXALENUM param, AXALS32* value)	const
{
	alGetSourcei(m_Source, param, value);
}

/**********************************************************************//**
 *
 * alGetSourcef
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	value	= l
*//***********************************************************************/
void CALPlayer::getf(AXALENUM param, AXALF32* value)	const
{
	alGetSourcef(m_Source, param, value);
}

/**********************************************************************//**
 *
 * alGetSource3i
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	v1		= l
 * @param [out]	v1		= l
 * @param [out]	v1		= l
*//***********************************************************************/
void CALPlayer::get3i(AXALENUM param, AXALS32* v1, AXALS32* v2, AXALS32* v3)	const
{
	alGetSource3i(m_Source, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alGetSource3f
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	v1		= l
 * @param [out]	v1		= l
 * @param [out]	v1		= l
*//***********************************************************************/
void CALPlayer::get3f(AXALENUM param, AXALF32* v1, AXALF32* v2, AXALF32* v3)	const
{
	alGetSource3f(m_Source, param, v1, v2, v3);
}

/**********************************************************************//**
 *
 * alGetSourceiv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	values	= lz
*//***********************************************************************/
void CALPlayer::getiv(AXALENUM param, AXALS32* values)	const
{
	alGetSourceiv(m_Source, param, values);
}

/**********************************************************************//**
 *
 * alGetSourcefv
 *
 ----------------------------------------------------------------------
 * @param [in]	param	= p[^
 * @param [out]	values	= lz
*//***********************************************************************/
void CALPlayer::getfv(AXALENUM param, AXALF32* values)	const
{
	alGetSourcefv(m_Source, param, values);
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "AXALSystem.h"
#include "AXALBuffer.h"
#include "../../iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CAXALPlayerUnitTest, AXALPlayerUnitTest)
{
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[4];
	system.Initialize();

	player.Initialize();
	for( int i=0; i < 4; ++i )	buffer[i].Initialize();

	player.Enqueue(&buffer[0]);
	IRIS_ASSERT( player.GetQueueBufferNum() == player.GetObserverNum() );
	IRIS_ASSERT( !player.IsPlay() );
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
