//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_filepath.hpp
 * @brief		iris unit test t@CpXNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_filepath_HPP_D69E7545_BF8A_4edc_9493_9105C69F9378_
#define INCG_IRIS_iutest_filepath_HPP_D69E7545_BF8A_4edc_9493_9105C69F9378_

#if !defined(IUTEST_USE_GTEST)

//======================================================================
// include
#include "iutest_string.hpp"
#include "iutest_port.hpp"

#if IUTEST_HAS_FILE_STAT
#  include <sys/stat.h>
#endif

#if	defined(_MSC_VER) && !defined(IUTEST_OS_WINDOWS_MOBILE)
#  include <direct.h>
#endif

namespace iutest {

namespace internal {
namespace posix
{

#if IUTEST_HAS_FILE_STAT

#if defined(IUTEST_OS_WINDOWS)

	typedef struct _stat StatStruct;

	inline int Stat(const char* path, StatStruct* buf) { return _stat(path, buf); }
	inline bool IsDir(const StatStruct& st) { return (st.st_mode & _S_IFDIR) != 0; }

#else

	typedef struct stat StatStruct;

	inline int Stat(const char* path, StatStruct* buf) { return stat(path, buf); }
	inline bool IsDir(const StatStruct& st) { return S_ISDIR(st.st_mode); }

#endif

#endif

}	// end of namespace posix
}	// end of namespace internal

namespace detail
{

//======================================================================
// class
/**
 * @brief	t@CpXNX
*/
class iuFilePath
{
public:
	iuFilePath(void) : m_path("") {}
	iuFilePath(const iuFilePath& rhs) : m_path(rhs.m_path) {}

	explicit iuFilePath(const char* path) : m_path(path)
	{
		Normalize();
	}
	explicit iuFilePath(const std::string& path) : m_path(path)
	{
		Normalize();
	}

public:
	std::string	ToString(void)	const	{ return m_path; }
	const char* c_str(void)		const	{ return m_path.c_str(); }
	bool		IsEmpty(void)	const	{ return c_str() == NULL || *c_str() == '\0'; }
	size_t		length(void)	const	{ return m_path.length(); }

public:
	bool operator == (const iuFilePath& rhs) const
	{
		return IsStringCaseEqual(c_str(), rhs.c_str());
	}
	bool operator == (const char* rhs) const
	{
		return IsStringCaseEqual(c_str(), rhs);
	}
	//operator const char* (void) const	{ return c_str(); }

public:

	/**
	 * @brief	tH_pXǂ
	*/
	bool	IsDirectory(void) const;

	/**
	 * @brief	[gfBNgpXǂ
	*/
	bool	IsRootDirectory(void) const;

	/**
	 * @brief	΃pXǂ
	*/
	bool	IsAbsolutePath(void) const;

	/**
	 * @brief	̃Zp[^[폜
	*/
	iuFilePath	RemoveTrailingPathSeparator(void) const;

	/**
	 * @brief	gq̍폜
	*/
	iuFilePath	RemoveExtension(const char* extention=NULL) const;

	/**
	 * @brief	fBNg̍폜
	*/
	iuFilePath	RemoveDirectoryName(void) const;

	/**
	 * @brief	t@C̍폜
	*/
	iuFilePath	RemoveFileName(void) const;

	/**
	 * @brief	tH_̍쐬
	*/
	bool		CreateFolder(void) const;

	/**
	 * @brief	tH_ċAIɍ쐬
	*/
	bool		CreateDirectoriesRecursively(void) const;

	/**
	 * @brief	t@C܂̓tH_݂邩ǂ
	*/
	bool		FileOrDirectoryExists(void) const;

	/**
	 * @brief	tH_݂邩ǂ
	*/
	bool		DirectoryExists(void) const;

	/**
	 * @brief	Ԍ̃pXZp[^̃AhX擾
	*/
	const char* FindLastPathSeparator(void) const;

public:
	/**
	 * @brief	JgfBNg̎擾
	*/
	static iuFilePath	GetCurrentDir(void);

	/**
	 * @brief	JgfBNg̑΃pX擾
	*/
	static iuFilePath	GetRelativeCurrentDir(void);

	/**
	 * @brief	st@C̃pX擾
	*/
	static iuFilePath	GetExecFilePath(void);

	/**
	 * @brief	pX̌
	*/
	static iuFilePath	ConcatPaths(const iuFilePath& directory, const iuFilePath& relative_path);

public:
	/**
	 * @brief	pX؂蕶̎擾
	*/
	static char	GetPathSeparator(void);

private:
	/**
	 * @biref	K
	*/
	void Normalize(void);

private:
	static bool IsPathSeparator(char c);
	static bool IsAltPathSeparator(char c);
private:
	std::string	m_path;
};

inline iu_ostream& operator << (iu_ostream& os, const iuFilePath& path)
{
	return os << path.c_str();
}

}	// end of namespace detail

namespace internal
{
	// google test Ƃ̌݊̂
	typedef detail::iuFilePath FilePath;
}

}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "../impl/iutest_filepath.ipp"
#endif

#endif

#endif
