//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_body.hpp
 * @brief		iris unit test eXgP̃NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_body_HPP_3EEA6706_9954_4330_B292_129667FA6B96_
#define INCG_IRIS_iutest_body_HPP_3EEA6706_9954_4330_B292_129667FA6B96_

//======================================================================
// include
#include "iutest_result.hpp"
#include "iutest_printers.hpp"
#include "internal/iutest_mediator.hpp"

namespace iutest
{

//======================================================================
// declare
class Test;
template<typename T>class WithParamInterface;
template<typename T>class TestWithParam;

//======================================================================
// class
/**
 * @brief	eXgx[X
*/
class Test
{
	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(Test);

public:
	Test(void)
		: test_info_(NULL)
		, m_test_info(NULL)
		, m_random_seed(0)
	{
		CurrentTestObserver::s_current = this;
	}

	virtual ~Test(void)
	{
		CurrentTestObserver::s_current = NULL;
	}

public:
	/**
	 * @brief	s TestInfo ̎擾
	*/
	static const TestInfo*	GetCurrentTestInfo(void)		{ return CurrentTestObserver::GetCurrentTestInfo(); }

	/**
	 * @brief	s Test ̎擾
	*/
	static Test*			GetCurrentTest(void)			{ return CurrentTestObserver::GetCurrentTest(); }


	/**
	 * @brief	vIȃG[oǂ
	 * @return	^Ul
	*/
	static bool	HasFatalFailure(void)
	{
		return GetCurrentTest()->m_test_info->HasFatalFailure();
	}

	/**
	 * @brief	vIł͂ȂG[oǂ
	 * @return	^Ul
	*/
	static bool	HasNonfatalFailure(void)
	{
		return GetCurrentTest()->m_test_info->HasNonfatalFailure();
	}

	/**
	 * @brief	G[oǂ
	 * @return	^Ul
	*/
	static bool	HasFailure(void)
	{
		return GetCurrentTest()->m_test_info->HasFailure();
	}

	/**
	 * @brief	eXgʂ̏ǉ
	 * @param [in]	key		= vpeB̃L[
	 * @param [in]	value	= l
	*/
	static void RecordProperty(const char* key, const char* value);

	/**
	 * @brief	eXgʂ̏ǉ
	 * @param [in]	key		= vpeB̃L[
	 * @param [in]	value	= l
	*/
	template<typename T>
	static void RecordProperty(const char* key, const T& value)
	{
		RecordProperty(key, PrintToString(value).c_str());
	}

#if IUTEST_HAS_GENRAND

	/**
	 * @brief	̐
	 * @note	V[h --iutest_random_seed Ŏw肵lɂȂ܂B
	 *			w肵Ȃꍇ͎sɌ肵܂B
	*/
	unsigned int	genrand(void)				{ return m_random.genrand(); }
	/**
	 * @overload
	 * @param [in]	max	= [0,max) ̗𐶐
	*/
	unsigned int	genrand(unsigned int max)	{ return m_random.genrand(max); }
	/** V[h̎擾 */
	unsigned int	random_seed(void)			{ return m_random_seed; }

#endif

protected:
	virtual	void	SetUp(void)		{}	//!< sO
	virtual void	Body(void)	= 0;	//!< eXg
	virtual void	TearDown(void)	{}	//!< s㏈

public:
	static	void	SetUpTestCase(void)		{}	//!< test case setup
	static	void	TearDownTestCase(void)	{}	//!< test case tear down

private:
	/**
	 * @brief	eXg̎s
	*/
	void Run(detail::iuITestInfoMediator* test_info);

private:
	template<typename DMY=void>
	class Observer
	{
	public:
		static Test*	s_current;
	public:
		static		 Test*		GetCurrentTest(void)		{ return s_current; }
		static const TestInfo*	GetCurrentTestInfo(void)	{ if( s_current == NULL || s_current->m_test_info == NULL ) return NULL; return s_current->m_test_info->ptr(); }
	};

	typedef Observer<void>	CurrentTestObserver;

protected:
	const TestInfo* test_info_;	//!< eXgɊȒPɃANZX\Ȃ悤

private:
	friend class UnitTest;
	friend class UnitTestImpl;
	friend class TestInfo;

	detail::iuITestInfoMediator*	m_test_info;
#if IUTEST_HAS_GENRAND
	detail::iuRandom				m_random;
	unsigned int					m_random_seed;
#endif
};

template<typename DMY>
Test*	Test::Observer<DMY>::s_current = NULL;

/**
 * @brief	p[^eXgC^[tF[X
 * @tparam	T = p[^^
*/
template<typename T>
class WithParamInterface
{
public:
	typedef T	ParamType;	//!< p[^^
protected:
	virtual ~WithParamInterface(void)	{}

public:
	/**
	 * @brief	p[^̎擾
	*/
	static const ParamType&	GetParam(void)						{ return *s_params; }

	/** @private */
	static void				SetParam(const ParamType* params)	{ s_params = params; }

private:
	static const ParamType*	s_params;
};

template<typename T>
const T* WithParamInterface<T>::s_params = NULL;

/**
 * @brief	p[^eXgx[X
 * @tparam	T = p[^^
*/
template<typename T>
class TestWithParam : public Test, public WithParamInterface<T>
{
};

}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "impl/iutest_body.ipp"
#endif

#endif
