//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_info.hpp
 * @brief		iris unit test  t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iutest_info_HPP_764A79A8_E822_4c0f_8CB7_82C635BA28BA_
#define INCG_IRIS_iutest_info_HPP_764A79A8_E822_4c0f_8CB7_82C635BA28BA_

//======================================================================
// include
#include "iutest_body.hpp"
#include "internal/iutest_factory.hpp"
#include "internal/iutest_exception.hpp"

namespace iutest
{

//======================================================================
// class
/**
 * @brief	eXgNX
*/
class TestInfo 
	: public detail::iu_list_node<TestInfo>
{
public:
	/**
	 * @brief	RXgN^
	 * @param [in]	testcase	= eXgP[X
	 * @param [in]	name		= eXg
	 * @param [in]	factory		= eXg
	*/
	TestInfo(detail::iuITestCaseMediator* testcase, const char* name, detail::iuFactoryBase* factory)
		: m_testname(name)
		, m_factory(factory)
		, m_testcase(testcase)
		, m_should_run(true)
		, m_ran(false)
		, m_disable(false)
		, m_skip(false)
		, m_matches_filter(true)
	{
		m_mediator.SetPointer(this);
		if( detail::IsStringForwardMatching(name, "DISABLED_") )
		{
			m_disable = true;
		}
	}

public:
	/** test case ̎擾 */
	const	char*	test_case_name(void)	const	{ return m_testcase->test_case_name(); }
	/** test ̎擾 */
	const	char*	name(void)				const	{ return m_testname.c_str(); }
	/** should_run */
	bool			should_run(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_should_run; }
	/** is ran */
	bool			is_ran(void)			const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_ran; }
	/** disable */
	bool			is_disabled_test(void)	const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_disable; }
	/** is skipped */
	bool			is_skipped(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_skip || m_test_result.Skipped(); }
	/** is reportable */
	bool			is_reportable(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return m_matches_filter; }
	/** eXg̎s~b */
	TimeInMillisec	elapsed_time(void)		const	{ return m_test_result.elapsed_time(); }
	/** eXgʂ̎擾 */
	const TestResult*	result(void)		const IUTEST_CXX_NOEXCEPT_SPEC	{ return &m_test_result; }

	/** value param ̎擾 */
	const	char*	value_param(void)		const	{ return m_value_param.empty() ? NULL : m_value_param.c_str(); }
	/** type param ̎擾 */
	const	char*	type_param(void)		const	{ return m_testcase->type_param(); }

public:
	/**
	 * @brief	vIȃG[oǂ
	 * @return	^Ul
	*/
	bool	HasFatalFailure(void) const
	{
		return m_test_result.HasFatalFailure();
	}

	/**
	 * @brief	vIł͂ȂG[oǂ
	 * @return	^Ul
	*/
	bool	HasNonfatalFailure(void) const
	{
		return m_test_result.HasNonfatalFailure();
	}

	/**
	 * @brief	G[oǂ
	 * @return	^Ul
	*/
	bool	HasFailure(void) const
	{
		return m_test_result.Failed();
	}

	/**
	 * @brief	ǂ
	 * @return	^Ul
	*/
	bool	Passed(void) const
	{
		if( is_skipped() ) return false;
		return m_test_result.Passed();
	}

public:
	/** eXg̃t擾 */
	::std::string	test_full_name(void)		const
	{
		::std::string fullname = test_case_name();
		fullname += ".";
		fullname += name();
		return fullname;
	}

	/** eXg + where ̎擾 */
	::std::string test_name_with_where(void)	const
	{
		::std::string str = m_testname;
		if( value_param() != NULL )
		{
			str += ", where GetParam() = ";
			str += m_value_param;
		}
		return str;
	}

public:
	/**
	 * @brief	LȃvpeBǂ`FbN
	 * @param [in] name	= vpeB
	 * @retval	true=L
	 * @retval	false=
	*/
	static bool ValidateTestPropertyName(const ::std::string& name)
	{
		const char* ban[] = { "name", "status", "time", "classname", "type_param", "value_param" };
#if !defined(IUTEST_NO_TEMPLATE_PARTIAL_SPECIALIZATION)
		return TestProperty::ValidateName(name, ban);
#else
		return TestProperty::ValidateName(name, ban, ban+IUTEST_PP_COUNTOF(ban));
#endif
	}
public:
	/** @private */
	void	set_value_param(const char* str)	{ m_value_param = str; }

private:
	/**
	 * @brief	s
	*/
	bool	Run(void);

private:

	void	RunImpl(void);

#if IUTEST_HAS_EXCEPTIONS && IUTEST_HAS_SEH
#if IUTEST_HAS_MINIDUMP
	void	MiniDump(_EXCEPTION_POINTERS* ep);
#endif
	void	RunOnMSC(detail::auto_ptr<Test>& test);
#endif

private:
	/**
	 * @brief	eXg̃NA
	*/
	void	clear(void);

	/*
	 * @brief	eXg̃tB^O
	 * @return	sꍇ͐^
	*/
	bool	filter(void);

private:
	class Mediator : public detail::iuITestInfoMediator
	{
	public:
		Mediator(TestInfo* p=NULL) IUTEST_CXX_NOEXCEPT_SPEC : iuITestInfoMediator(p) {}
	public:
		virtual	bool	HasFatalFailure(void) const IUTEST_CXX_OVERRIDE IUTEST_CXX_FINAL
		{
			return ptr()->HasFatalFailure();
		}
		virtual	bool	HasNonfatalFailure(void) const IUTEST_CXX_OVERRIDE IUTEST_CXX_FINAL
		{
			return ptr()->HasNonfatalFailure();
		}
		virtual bool	HasFailure(void) const IUTEST_CXX_OVERRIDE IUTEST_CXX_FINAL
		{
			return ptr()->HasFailure();
		}
	public:
		void SetPointer(TestInfo* p) { m_test_info = p; }
	};
private:
	friend class UnitTestImpl;
	friend class UnitTest;
	friend class TestCase;

	::std::string			m_testname;			//!< eXg
	::std::string			m_value_param;		//!< value param string
	TestResult				m_test_result;		//!< eXg
	Mediator				m_mediator;			//!< g̒CX^X
	detail::iuFactoryBase*			m_factory;	//!< eXg
	detail::iuITestCaseMediator*	m_testcase;	//!< eXgP[X
	bool					m_should_run;		//!< sׂ̐^Ul
	bool					m_ran;				//!< sǂ
	bool					m_disable;			//!< ^Ul
	bool					m_skip;				//!< XLbvǂ
	bool					m_matches_filter;	//!< tB^[Ƀ}b`ǂ

	IUTEST_PP_DISALLOW_COPY_AND_ASSIGN(TestInfo);
};

}	// end of namespace iutest

#if !IUTEST_HAS_LIB
#  include "impl/iutest_info.ipp"
#endif

#endif
