/**
 *　Dragunova.js /ドラグノフJS
 * 2chのレスを編集可能にするJS
 * @author TouyouHacker (東洋黒客 twitter:@touyou_hk)
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 * https://sourceforge.jp/projects/j2chmatometter/
 */

// TODO グローバル変数汚染対策が必要
var copyResCounter = 0;
var RES_NUM_KEYID = "resNum";
var RES_NUM_DD = "resDNum";

$(function() {
	
	// スレ読み込みボタンイベント登録
	$("#threadReadButton").click(
			function(){
				readTreadToIframe();
			});
	
	// コピー先でレス番号がズレた時のためにレス番号でソートし直します
	$("#sortResNumber").click(
			function(){
				sortResNumber($("#editFrame"));
			});
	
	$("#threadReadButton").button();
	$("#sortResNumber").button();
	$("#moveDetailEdit").button();
	
	// プラグイン用チェックボックスのイベント登録
	pluginCheckBoxAllOnload();
	
	//　プラグイン実行ボタンへのイベント登録
	$("#plugInExecute").click(
			function() {
				var $htmlObj = $("#editFrame");
				pluginExecuter($htmlObj);
				
			}
			);
	
	// レス単位コントロールパネルのイベント登録
	$(".controlPanelLink").live("mouseenter",
			function(){
				$(this).css("text-decoration" , "underline");
	});
	$(".controlPanelLink").live("mouseleave",
			function(){
				$(this).css("text-decoration" , "none");
	});
});

/**
 * AJAX通信でスレを取得する
 * AJAXはクロスドメイン通信ができないためローカルサーバーに2ch通信させてスレを取得させる
 * CliantJS → [AJAX]-LocalServer → [HTTP]-2ch
 * 
 * ローカルサーバーはプロクシでも代用可(単純にスレHTMLを取得するだけなら・・dat取得等は考慮が必要)
 * ローカルサーバーAPロジックは何でも可能 (Tomcat/JSP,Apache-Perl/PHP/Ruby)
 */
function readTreadToIframe(){
	if(urlValidater() === false){
		return;
	}
	
	//ex:http://localhost:8080/2chMtMt4Jsp/GetWebContentsServlet?url=http://kilauea.bbspink.com/test/read.cgi/hgame2/1333342832/
	var getApName = "GetWebContentsServlet";
	var baseUrl= getApName + "?url=";
	var reqUrl= $("#threadUrl").val();
	
	var getUrl = baseUrl + reqUrl;

	var param2 = "&encode=";
	
	// 読み込んだHTMLから読み込み開始するセレクタの設定
	// 2chのデフォ
	var readStartSelecter = ".thread";
	
	// ホストのジャッジ
	var judgeResult = dragunovaUtil_judgeBordHost(getUrl);
	if (DRAGUNOVA.bordListName.sitaraba === judgeResult) {
		
		// したらば掲示板の場合
		readStartSelecter = "#thread-body";
		
		// エンコードを指定する
		getUrl = getUrl + param2 + "euc-jp";
		
	}
	
	// IE8というかIE? での.loadバグ
	// http://stackoverflow.com/questions/7213980/jquery-load-method-not-working-ie8
//	if($.browser.msie) {
//		getUrl = getUrl + Math.random()*99999 ;
//	}
	
	
	if($.browser.msie) {
		$.ajaxSetup({ cache: false });
		$.ajax({
			url: getApName,
			dataType: "html",
			cache: false,
			data: {"url":reqUrl},
			success: function(data){
				alert(data);
			var $orignHtml = $(data);	
			 $("#threadFrame").html( $orignHtml.find(readStartSelecter).html() );	
			}
		});
		
		return;
	}
	
	
		 $("#threadFrame").load(getUrl + " " + readStartSelecter,
			function(data) {
			 	threadViewWorks($("#threadFrame"));
			 	editAble();
//			 	if($.browser.msie) {
//			 		data.preventDefault();
//			 	}
		 	});
	/*
	 * $.get( getUrl, function (data) { alert(data);
	 * $("#threadFrame").html(data); } );
	 */
	
}

function writeHtmlTo() {
	$("#copyHtmlFrame").html($("#editFrame").html());
}

/**
 * URLの正当性をチェックする関数
 * 2ch系以外のURLをiframeに読み込ませない
 */
function urlValidater() {
	
	// チェックにひかかったらアラート
	if ($("#threadUrl").val() === "") {
		common_alert("", "読み込みURLが指定されていません。");
		return false;
	}
}

// スレを編集可能にする
//TODO レス順の入れ替え可能にする
//TODO レスのオートトレースオプション機能も必要(レス内にアンカーがあったらそのレスもコピーする)
function editAble () {
	// スレッドのdt dd要素をひとまとめにする
	$("#editFrame").html("");
	copyResCounter = 0;
	$("#copyCounter").text(copyResCounter);
	
	$("#threadFrame").contents().find("dd").addClass("copy");
	
	var threadFrameControlPanelHtml = $("#threadFrameControlPanelRap").html();
	
	$('.copy').mouseenter(
			function(){
				if ($(this).data(".copyed") === "1"){
					return;
				} 
				
				$(this).changeResBgColor("#ff9999");
				
				$(this).threadFrameControlPanelWork(threadFrameControlPanelHtml);
				
	});
	
	$('.copy').mouseleave(
			function(){
				if ($(this).data(".copyed") === "1"){
					return;
				} 				
				$(this).changeResBgColor("#ffffff");
				$(this).threadFrameControlPanelWork();
	});
	
	$('.copy').dblclick(
			function(){
				// 1レスをコピーします
				copyResBlockEvent($(this));
			});
	

	
	/*
	// dtddにドラッククラスを付与する
	// class=draggable
	$("#threadFrame").contents().find("dt,dd").addClass("draggable");
	$(".draggable").draggable();
	
	// エディットDIVをドラッグ可能領域に設定する
	$("#editFrame").addClass("droppable");
	$('.droppable').droppable({
		accept: '.draggable',
		drop: function (e, ui){		
		}
	});
	*/
	
	var copyFrameControlPanelHtml = $("#copyFrameControlPanelRap").html();
	
	// Rightフレーム Liveでイベント登録
	$("#editFrame").find("dd").live("mouseenter",
			function(){
				$(this).changeResBgColor("#ff9999");
				$(this).copyFrameControlPanelWork(copyFrameControlPanelHtml);
	});
	
	$("#editFrame").find("dd").live("mouseleave",
			function(){				
				$(this).changeResBgColor("#ffffff");
				$(this).copyFrameControlPanelWork();
	});
	
	// レスを選択してる時にダブルクリックしたら削除し左フレームのcopyedを元に戻す
	$("#editFrame").find("dd").live("dblclick", function() {
		// 1レスを削除し元に戻します
		deleteResBlock($(this));
	});
	
	
	//*----- スレッドフレーム・コントロールパネル
	
	// 1レスコピー
	$("#resCopy").live("click",function () {
			//alert($(this).parent().parent().html());
			copyResBlockEvent($(this).parent().parent());
	});
	$("#resCopyImg").live("click",function () {
			copyResBlockEvent($(this).parent().parent());
	});
	
	
	//*----- コピーフレーム・コントロールパネル
	// 1レス削除
	$("#resDelete").live("click",function () {
		deleteResBlock($(this).parent().parent());
	});
	$("#resDeleteImg").live("click",function () {
		deleteResBlock($(this).parent().parent());
	});
	
	// 上へ移動
	$("#resMoveUp").live("click",function () {
		moveUpResBlock($(this).parent().parent());
	});
	$("#resMoveUpImg").live("click",function () {
		moveUpResBlock($(this).parent().parent());
	});
	
	// 下へ移動
	$("#resMoveDown").live("click",function () {
		moveDownResBlock($(this).parent().parent());
	});
	$("#resMoveDownImg").live("click",function () {
		moveDownResBlock($(this).parent().parent());
	});
}



function moveDetailEdit() {
	writeHtmlTo();
	$("#copyHtmlSubmit").click();
}


/* TODO 処理中がわかるダイアログかローディング画面が必要
 * 各プラグインの処理中がわかるメッセージが必要
*/
/**
 * プラグインを実行します
 * @param $htmlObj jQuery HTMLオブジェクト
 */
function pluginExecuter($htmlObj){
 	
	// TODO 各プラグインの実行順序が変更されても正常に動作するよう注意する
	// プラグインのほうで処理矛盾が起こらないように注意する必要がある
	
	// TODO プラグイン実行後、操作を取り消したい場合、取り消しができるボタンが必要
	
	// TODO プラグインの総合処理時間は画面に出せるようにする
	
 	if($("#imeNuLinkDelete").judgeCheckBox()){
 		$htmlObj.imeNuLinkDelete();
 	}
 	
 	if($("#pinkTowerLinkDelete").judgeCheckBox()){
 		$htmlObj.pinkTowerLinkDelete();
 	}
 	
 	if($("#beLinkImageDelete").judgeCheckBox()){
 		$htmlObj.beLinkImageDelete();
 	}
 	
 	if($("#nameLessAllChange").judgeCheckBox()){
 		// 変更したい名前を取得
 		var changedName = $("#nameLessChangeText").val();
 		$htmlObj.nameLessAllChange(changedName);
 	}
 	
 	if($("#mailDelete").judgeCheckBox()){
 		jQuery.fn.mailDelete.color = "green";
 		$htmlObj.mailDelete();
 	}
 	
 	if($("#hyperLinkRecover").judgeCheckBox()){
 		$htmlObj.hyperLinkRecover();
 	}
 	
 	if($("#delLinkAnchor").judgeCheckBox()){
 		jQuery.fn.delLinkAnchor.color = "blue";
 		$htmlObj.delLinkAnchor();
 	}
 	
}

/**
 * スレッドビューワー用の処理を行います
 * @param HTML jQueryオブジェクト
 */
function threadViewWorks($htmlObj){
	$htmlObj.setResDataNum();
	
	// ID単位のレス数 NOW値/MAX値を表示
	jQuery.fn.idCounterView.dspNowMax = true;
	jQuery.fn.idCounterView.strongNum = 5;
	// ID強調表示を実行
	$htmlObj.idCounterView();
	
	// アンカー強調表示を実行
	jQuery.fn.resAnchorView.numDsp = true;
	$htmlObj.resAnchorView();
}


/**
 * レスの順番どおりにソートするメソッド
 * @param jQuery Object
 */
function sortResNumber($htmlObj){
	// Step1  レス番号を見てdataで紐付け
	// Step2  レス番号順にソート
	// Step3 仮想空間にソート後のHTMLをコピー
	// Step4 copyDivのHTMLをクリア (レス順用のデータが消えないように注意)
	// Step5 ソートしたHTMLをcopyDivに貼り付け
	var nums;
	
	//<dt style="background-color: rgb(255, 255, 255);">11 ：<a href="mailto:sage"><b>風の谷の名無しさん＠実況は実況板で</b></a>：2012/05/04(金) 01:17:25.87 ID:8nFHfWaV0</dt>
	
	//Step1  レス番号を見てdataで紐付け
	var $targets = $htmlObj.find("dt");
	var text;
	
	// レス番号ソート用の配列
	var resNumArray = [];
	var resNumArrayIndex = 0;
	
	// レス番号を抽出する正規表現
	var findResNumRegex = /^\d{1,4}/;
	$targets.each(function() {
		text = $(this).text();
		nums = text.match(findResNumRegex);
		$(this).data(RES_NUM_KEYID,nums[0]);
		
		resNumArray[resNumArrayIndex] = nums[0];
		resNumArrayIndex++;
	});
	
	// Step2  レス番号順にソート
	resNumArray.sort(compareNumbers);
	
	// DD順でのレス番号を格納する配列とindex
	var resDdNumArray = [],resDdNumArrayIndex=0;
	
	for(var num in resNumArray){
		$targets.each(function() {
			if (resNumArray[num] == $(this).data(RES_NUM_KEYID)){
				// Step3 仮想空間にソート後のHTMLをコピー
				// 配列順に#editFrameForSortにappend
				$("#editFrameForSort").append("<dt>" + $(this).html() + "</dt>");
				$("#editFrameForSort").append("<dd>" + $(this).next().html() + "</dd>");
				
				// レス番号(DD順)を保存
				resDdNumArray[resDdNumArrayIndex]=$(this).next().data(RES_NUM_DD);
				resDdNumArrayIndex++;
				
				// Step4 copyDivのHTMLをクリア 
				$(this).remove();
				$(this).next().remove();
				
				return;
			}
		});
	}

	// Step5 ソートしたHTMLをcopyDivに貼り付け
	$("#editFrame").html($("#editFrameForSort").html());
	
	resDdNumArrayIndex=0;
	// DD順のデータを復元
	$("#editFrame").find("dd").each(function() {
		$(this).data(RES_NUM_DD, resDdNumArray[resDdNumArrayIndex]);
		resDdNumArrayIndex++;
	});
	
	// コピーが終わったらeditFrameForSortの中身はクリア
	$("#editFrameForSort").html("");
}

/**
 * スレッドフレームコントロールパネルの表示・非表示を操作します
 * @this dd Selecter
 * @param threadFrameControlPanelのHTML
 */
jQuery.fn.threadFrameControlPanelWork = function(threadFrameControlPanelHtml){
	var finder = $(this).find("#threadFrameControlPanel");
	
	if(finder.length === 0) {
		// threadFrameControlPanel を付加して表示
		$(this).append(threadFrameControlPanelHtml);
		$(this).find("#threadFrameControlPanel").css("display","inline");
	} else {
		// threadFrameControlPanel要素を削除
		$(this).find("#threadFrameControlPanel").remove();
	}
};

/**
 * コピーフレームコントロールパネルの表示・非表示を操作します
 * @this dd Selecter
 * @param copyFrameControlPanelのHTML
 */
jQuery.fn.copyFrameControlPanelWork = function(copyFrameControlPanelHtml){
	var finder = $(this).find("#copyFrameControlPanel");
	
	if(finder.length === 0) {
		// copyFrameControlPanel を付加して表示
		$(this).append(copyFrameControlPanelHtml);
		$(this).find("#copyFrameControlPanel").css("display","inline");
	} else {
		// copyFrameControlPanel要素を削除
		$(this).find("#copyFrameControlPanel").remove();
	}
};


/**
 * DDセレクターを受け取り1レスブロック(DT+DD)をコピーフレームにコピーします(画面ボタンイベント用)
 * スレッドフレーム・コントロールパネルを除去した後、コピー処理を実施します
 * @param $ddSelecter
 */
function copyResBlockEvent($ddSelecter){
	// コントロールパネルを除去
	$ddSelecter.threadFrameControlPanelWork();
	copyResBlock($ddSelecter);
}

/**
 * DDセレクターを受け取り1レスブロック(DT+DD)をコピーフレームにコピーします
 * @param $ddSelecter
 */
function copyResBlock($ddSelecter){
	if ($ddSelecter.data(".copyed") === "1"){
		return;
	} 

	copyResCounter++;
	
	$("#editFrame").append("<dt>" + $ddSelecter.prev().html() + "</dt>");
	$("#editFrame").append("<dd>" + $ddSelecter.html() + "</dd>");
	
	//コピー先のオブジェクトをキャッシュ
	var $dt = $("#editFrame").find("dt:last");
	var $dd = $("#editFrame").find("dd:last");
	
	// スレッドビュー用の装飾を除去
	$dt.threadViewDelete();
	$dd.threadViewDelete();
	
	// レス番号を紐付ける
	$dd.data(RES_NUM_DD,$ddSelecter.data(RES_NUM_DD));
	
	$("#copyCounter").text(copyResCounter);
	
	// レスグループの背景色変更
	$ddSelecter.changeResBgColor("silver");
	
	$ddSelecter.data(".copyed","1");
}

/**
 * DDセレクターを受け取りコピーフレームの1レスブロック(DT+DD)を削除します
 * スレッドフレームの該当ブロックを「コピー済」から「コピー未実施」にステータスを元に戻します
 * @param $ddSelecter
 */
function deleteResBlock($ddSelecter){
	// 該当のレス番号を取得
	var resNum = $ddSelecter.data(RES_NUM_DD);
	// jQuery配列の番号とレス番号を調整
	resNum--;
	
	// 要素を削除
	$ddSelecter.prev().remove();
	$ddSelecter.remove();

	
	// 左フレームの該当レスの色を元に戻す
	$("#threadFrame").find("dd:eq(" + resNum + ")").changeResBgColor("#ffffff");
	// 左フレームの該当レスのコピー状態を元に戻す
	$("#threadFrame").find("dd:eq(" + resNum + ")").data(".copyed","");
	
	// カウンターを調整
	copyResCounter--;
	$("#copyCounter").text(copyResCounter);
}


/**
 * DDセレクターを受け取りコピーフレームの1レスブロック(DT+DD)を上に移動します
 * 最上位にあるときは何もしません。
 * @param $ddSelecter
 */
function moveUpResBlock($ddSelecter){
	
	$ddSelecter.copyFrameControlPanelWork();
	
	var $preBlockDD = $ddSelecter.prev().prev();
	
	// コピーフレームに1レスしかない時の処理→なにもしない
	if ($preBlockDD.length === 0) {
		alert("これ以上、上に移動できません。");
		return;
	}
	// スレッドフレームのDD順の番号を保存
	var ddOrder = $ddSelecter.data(RES_NUM_DD);
	
	$preBlockDD.prev().before( "<dt>" + $ddSelecter.prev().html() + "</dt>");
	$preBlockDD.prev().before( "<dd>" + $ddSelecter.html() + "</dd>");
	$preBlockDD.prev().prev().data(RES_NUM_DD, ddOrder);

	$ddSelecter.prev().remove();
	$ddSelecter.remove();
}

/**
 * DDセレクターを受け取りコピーフレームの1レスブロック(DT+DD)を下に移動します
 * 最下位にあるときは何もしません。
 * @param $ddSelecter
 */
function moveDownResBlock($ddSelecter){
	
	$ddSelecter.copyFrameControlPanelWork();
	
	var $nextBlockDD = $ddSelecter.next().next();
	
	if($nextBlockDD.length === 0) {
		//コピーフレームに1レスしかない時の処理
		alert("これ以上、下に移動できません。");
		return;
	}
	
	// スレッドフレームのDD順の番号を保存
	var ddOrder = $ddSelecter.data(RES_NUM_DD);

	$nextBlockDD.after("<dd>" + $ddSelecter.html() + "</dd>");
	$nextBlockDD.next().data(RES_NUM_DD, ddOrder);
	$nextBlockDD.after("<dt>" + $ddSelecter.prev().html() + "</dt>");
	
	$ddSelecter.prev().remove();
	$ddSelecter.remove();
}