/*
 * jquery.zweiChDat2Html.js (zwei Channel Dat to Html)
 * 2ch-DatをHTMLに変換するメソッド群
 * 
 * 
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */

// [開発者・注意]　DatからHTMLへの変換はある程度サーバーAP側（サーブレット等）でやったほうがいい気がする
// このJSライブラリでは一応、JS自身でパースする想定で実装する。
// 想定では　サーブレットがDATを取得、JSがそれをAJAXで取得、JSのこのライブラリで正規表現でHTML化してその後は通常のｊQuery操作


/*  1レスブロック（サンプル)
	<dt>
		50 ：
		<a href="mailto:sage">
			<b>名無しさん</b>
		</a>
		：2012/05/06(日) 07:12:29.33 ID:i3ovtOvP0
	</dt>
	<dd> 
		あいうえおかきくけこ。 <br><br>
	</dd>
*/

/**
 * テキスト形式のレスをHTML化します。
 * 2chブラウザ等でコピーしたテキストをHTML化したい時に使用。
 * レス内容をCLEitorのHTML画面に貼り付けて使用
 * 
 * @param Dat形式のレスに最低限の改行を入れたテキストを.htmlに格納したもの
 */
jQuery.fn.resText2Html = function(){
	/*
50 名前：名無しさん[sage] 投稿日：2012/05/06(日) 07:12:29.33 ID:i3ovtOvP0
あいうえおかきくけこ
	 */
	
	// 改行はCLEditorで自動で<br>する
	
	/*
	 * Logic-Step
	 * 1,<br>でsplit
	 * 2,正規表現でdtに該当するブロックを見つけてdtをつけ、aタグをつけ、bタグをつける (beとかの処理は面倒なので未対応)
	 * 3,dtを見つけたらその次のdtまではddブロックとしてループ処理を書けてdtで囲む
	 * 
	 */
	var orignHtml = jQuery(this).html();
	var result;
	
	jQuery(this).html(result);
	return this;
};