/**
 *　Dragunova.js /ドラグノフJS
 * 2chのレスを編集可能にするJS
 * @author TouyouHacker (東洋黒客 twitter:@touyou_hk)
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 */

var copyResCounter = 0;

$(function() {
	
	// スレ読み込みボタンイベント登録
	$("#threadReadButton").click(
			function(){
				readTreadToIframe();
			});
	
	// HTML書き出しボタン登録
	$("#writeEditedHtml").click(
			function(){
				writeHtmlTo();
			});
	
	// デバッグ用-スレHTMLを編集可能とする
	$("#editAbleHtml").click(
			function(){
				editAble();
			});
	
	$("#threadReadButton").button();
	$("#writeEditedHtml").button();
	$("#moveDetailEdit").button();
	$("#moveHstList").button();
});

/**
 * AJAX通信でスレを取得する
 * AJAXはクロスドメイン通信ができないためローカルサーバーに2ch通信させてスレを取得させる
 * CliantJS → [AJAX]-LocalServer → [HTTP]-2ch
 * 
 * ローカルサーバーはプロクシでも代用可(単純にスレHTMLを取得するだけなら・・dat取得等は考慮が必要)
 * ローカルサーバーAPロジックは何でも可能 (Tomcat/JSP,Apache-Perl/PHP/Ruby)
 */
function readTreadToIframe(){
	if(urlValidater() === false){
		return;
	}
	
	//ex:http://localhost:8080/2chMtMt4Jsp/GetWebContentsServlet?url=http://kilauea.bbspink.com/test/read.cgi/hgame2/1333342832/

	var baseUrl= "GetWebContentsServlet?url=";
	var reqUrl= $("#threadUrl").val();
	
	var getUrl = baseUrl + reqUrl;

	var param2 = "&encode=";
	
	// 読み込んだHTMLから読み込み開始するセレクタの設定
	// 2chのデフォ
	var readStartSelecter = ".thread";
	
	// ホストのジャッジ
	var judgeResult = dragunovaUtil_judgeBordHost(getUrl);
	if (DRAGUNOVA.bordListName.sitaraba === judgeResult) {
		
		// したらば掲示板の場合
		readStartSelecter = "#thread-body";
		
		// エンコードを指定する
		getUrl = getUrl + param2 + "euc-jp";
		
	}
	
	// IE8というかIE? での.loadバグ
	// http://stackoverflow.com/questions/7213980/jquery-load-method-not-working-ie8
//	if($.browser.msie) {
//		getUrl = getUrl + Math.random()*99999 ;
//	}
	

		 $("#threadFrame").load(getUrl + " " + readStartSelecter,
			function(data) {
			 	editAble();
//			 	if($.browser.msie) {
//			 		data.preventDefault();
//			 	}
		 	});
	/*
	 * $.get( getUrl, function (data) { alert(data);
	 * $("#threadFrame").html(data); } );
	 */
	
}

function writeHtmlTo() {
	$("#copyHtmlFrame").html($("#editFrame").html());
}

/**
 * URLの正当性をチェックする関数
 * 2ch系以外のURLをiframeに読み込ませない
 */
function urlValidater() {
	
	// チェックにひかかったらアラート
	if ($("#threadUrl").val() === "") {
		common_alert("", "読み込みURLが指定されていません。");
		return false;
	}
}

//スレを編集可能にする(DEBUG)
// 編集後のレス削除、レス順の入れ替え可能にする,フォントサイズと色変えの機能は必須
// レスのオートトレースオプション機能も必要(レス内にアンカーがあったらそのレスもコピーする)
// 名前をかえる機能（一括置換)
// 2chブラウザみたいに　レスをもらってるレスとIDごとの投稿数の表示
function editAble () {
	// スレッドのdt dd要素をひとまとめにする
	$("#editFrame").html("");
	copyResCounter = 0;
	$("#copyCounter").text(copyResCounter);
	
	$("#threadFrame").contents().find("dd").addClass("copy");
	
	$('.copy').mouseenter(
			function(){
				if ($(this).data(".copyed") === "1"){
					return;
				} 
				
				$(this).css("background-color","#ff9999");
	});
	
	$('.copy').mouseleave(
			function(){
				if ($(this).data(".copyed") === "1"){
					return;
				} 
				
				$(this).css("background-color","#ffffff");
	});
	
	$('.copy').dblclick(
			function(){
				if ($(this).data(".copyed") === "1"){
					return;
				} 
				
				copyResCounter++;
				
				$("#editFrame").append("<dt>" +  $(this).prev().html() + "</dt>");
				$("#editFrame").append("<dd>" +  $(this).html() + "</dd>");
				
				$("#copyCounter").text(copyResCounter);
				
				$(this).css("background-color","silver");
				
				$(this).data(".copyed","1");
			});
	
	/*
	// dtddにドラッククラスを付与する
	// class=draggable
	$("#threadFrame").contents().find("dt,dd").addClass("draggable");
	$(".draggable").draggable();
	
	// エディットDIVをドラッグ可能領域に設定する
	$("#editFrame").addClass("droppable");
	$('.droppable').droppable({
		accept: '.draggable',
		drop: function (e, ui){		
		}
	});
	*/
}


function moveDetailEdit() {
	writeHtmlTo();
	$("#copyHtmlSubmit").click();
}

/**
 * HTMLオブジェクトを受け取りIMEリンクを削除します
 * @param $htmlObj
 * @returns
 */
function imeLinkDelete($htmlObj){
}