/**
 *　dragunovaUtil.js /ドラグノフ-ユーティリティJS
 *
 *　2ch、2ch系掲示板の操作に使用できる関数と変数の定義JS
 *
 * ドラグノフで汎用的に使用公開できるメソッド、変数群を定義。
 * Gihub等で公開予定
 * 
 * @author TouyouHacker (東洋黒客 twitter:@touyou_hk)
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 */

var DRAGUNOVA = {};

DRAGUNOVA.version = "0.1.0";

DRAGUNOVA.bordList = {};
DRAGUNOVA.bordList.sitaraba = "jbbs.livedoor.jp";

DRAGUNOVA.bordListName = {};
DRAGUNOVA.bordListName._2ch = "2ch";
DRAGUNOVA.bordListName.sitaraba = "したらば掲示板";

/**
 * URLを読み込み掲示板を判定します
 * @param url 読み込むURL
 * @return 判定結果　掲示板
 */
function dragunovaUtil_judgeBordHost(url) {
	//http://jbbs.livedoor.jp/bbs/read.cgi/sports/1949/1331435025/l50
	
	var hostArray = url.split("/");
	
	if (hostArray[2] === DRAGUNOVA.bordList.sitaraba) {
		return DRAGUNOVA.bordListName.sitaraba;
	}
	
	// 他の掲示板でなかったら2chと判断
	return DRAGUNOVA.bordListName._2ch;
}
