/*
 * jquery.z2chmatome.js (Z-2chMatome)
 * 2chを編集、装飾可能にするjQueryプラグイン
 * 主に2chまとめ記事作成のために必要な関数を揃えています。
 * 
 * Jsライブラリのため2ch(HTML版)をターゲットとしています
 * 2ch(DAT版)はターゲットとしてないのでDATをHTMLに変換して当ライブラリを使用してください。
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */

// TODO 全体的に各関数で独立して使用を想定してるのでキャッシュやパフォーマンスを考慮してないが後で改良する

/**
 * ime.nuリンクの削除を実施します
 * 例　http://ime.nu/wwww.goooogle/1.jpg　→ http://www.goooogle/1.jpg
 *    httpsにも対応
 * 2ch-HTML 用
 * @selecter 2chHTML (.threadクラス以降のHTML)
 */
jQuery.fn.imeNuLinkDelete = function() {
	
	// Aリンクを抽出
	var $links = jQuery(this).find("dd").find("a");
	
	// eachで繰り返し処理
	var link,linkchg;
	$links.each(function() {
		link = $(this).attr("href");
		linkchg = null;
		// 正規表現処理にメールリンクやレスアンカーをひっかけないためフィルタする
		if( link.indexOf("http",0) == 0){
			// 「ime.nu/」を削除
			linkchg = link.replace("://ime.nu/","://");
			
			// alert(link + "->" + linkchg);
			
			// TODO 書き換えてないリンクも再設定してしまうので回避したい
			// 書き換えたリンクを再設定
			$(this).attr("href", linkchg);
		}
	});
	return this;
};


// TODO 後でime.nuと関数一緒にする
/**
 * pinktower.comリンクの削除を実施します(半角板用)
 * 例 http://pinktower.com/up.null-x.com/img/poverty6703.jpg　→ http://up.null-x.com/img/poverty6703.jpg
 *    httpsにも対応
 * 2ch-HTML 用
 * @selecter 2chHTML (.threadクラス以降のHTML)
 */
jQuery.fn.pinkTowerLinkDelete = function() {
	
	// Aリンクを抽出
	var $links = jQuery(this).find("dd").find("a");
	
	// eachで繰り返し処理
	var link,linkchg;
	$links.each(function() {
		link = $(this).attr("href");
		linkchg = null;
		// 正規表現処理にメールリンクやレスアンカーをひっかけないためフィルタする
		if( link.indexOf("http",0) == 0){
			// 「ime.nu/」を削除
			linkchg = link.replace("://pinktower.com/","://");
			
			// TODO 書き換えてないリンクも再設定してしまうので回避したい
			// 書き換えたリンクを再設定
			$(this).attr("href", linkchg);
		}
	});
	return this;
};

/**
 * メールアドレスリンクの削除を行います
 * 例  <a href="mailto:C%E2%80%A0C"><b>名無しさん＠初回限定</b></a> 
 * 　　　　　↓
 *     <b>名無しさん＠初回限定</b>
 * 2ch-HTML 用
 * 
 * [オプション]
 *  jQuery.fn.mailDelete.color = "名前欄の色を指定(HTML表記)" 
 * 
 * @selecter 2chHTML (.threadクラス以降のHTML)
 */
jQuery.fn.mailDelete = function() {
	//// <a href="mailto:C%E2%80%A0C"><b>名無しさん＠初回限定</b></a>
	
	// オプションを取得
	var nameColor = jQuery.fn.mailDelete.color;
	
	// Aリンクを抽出
	var $links = jQuery(this).find("dt a");
	
	// eachで繰り返し処理
	var link,changeHtml;
	$links.each(function() {
		link = $(this).attr("href");
		// a要素をmailtoでフィルタする
		if( link.indexOf("mailto:",0) == 0){

			changeHtml = $(this).html();
			
			 //　名前欄の色 2chデフォ green
			 // <font color="green"><b>風の谷の名無しさん＠実況は実況板で</b></font>
			 if (nameColor != null) {
				 // 色が指定されている場合色をつける
				 changeHtml = ( '<font color="' + nameColor + '">'  + changeHtml + "</font>");
			 }
			
			// リンクタグを削除する
			 $(this).replaceWith(changeHtml);
		}
	});
	return this;
	
};

/**
* 名無しの一括置換をします(県名表示板未対応版)
* 使用未推奨
*
* 例：<b>風の谷の名無しさん＠実況は実況板で</b>　→　<b>引数に指定された名前</b>
*
* 2ch-HTML 用
* @selecter 2chHTML (.threadクラス以降のHTML)
* @param changedName 変更したい名前
*/
jQuery.fn.nameLessAllChangeStd = function(changedName) {
/*
* <dt style="background-color: rgb(255, 255, 255);">2 ：
* <a href="mailto:sage">
* <b>風の谷の名無しさん＠実況は実況板で</b>
* </a>
* ：2012/04/15(日) 21:10:54.33 ID:9G71Zor00
* </dt>
*/

// 名前欄を取得
var $targets = jQuery(this).find("dt b");

// eachで繰り返し処理
$targets.each(function() {
$(this).text(changedName);
});
return this;
};

/**
 * 名無しの一括置換をします
 * 
 * 例：<b>風の谷の名無しさん＠実況は実況板で</b>　→　<b>引数に指定された名前</b>
 * 
 * 2ch-HTML 用
 * @selecter 2chHTML (.threadクラス以降のHTML)
 * @param changedName 変更したい名前
 */
jQuery.fn.nameLessAllChange = function(changedName) {
	/*
	 * ◯通常
	 * <dt style="background-color: rgb(255, 255, 255);">2 ：
	 * 	<a href="mailto:sage">
	 * 		<b>風の谷の名無しさん＠実況は実況板で</b>
	 * 	</a> 
	 *  ：2012/04/15(日) 21:10:54.33 ID:9G71Zor00
	 * </dt>
	 * 
	 * ◯ニュース速報(イミフなbタグが3つ存在する)
	 * <dt>849 ：
	 * 	<a href="mailto:sage">
	 * 		<b> </b>カペラ
	 *  	<b></b>(京都府)
	 *  	<b></b>
	 *  </a>：2012/04/15(日) 23:01:50.22 ID:tuqaTimY0
	 *  </dt>
	 */
	
	// 名前欄を取得
	var $targets = jQuery(this).find("dt");
	
	var $hit;
	// eachで繰り返し処理
	$targets.each(function() {
		$hit = $(this).find("b");
		if($hit.length > 1) {
			//ニュース速報等の県名表示板用の処理(<b>要素が3つある、また<b>が2つ存在するパターンもある)
			
			// 最初に出現する<b>要素の親のhtmlを置き換え
			// parent要素は、メアドがある時は<A>、ないときは<font>
			$(this).find("b:eq(0)").parent().html("<b>" +  changedName + "</b>");
			
		}else{
			// 通常処理
			$hit.text(changedName);
		}
		});
};


/**
 * BeリンクとBe画像の削除を行います
 * 
 * 使用例： $htmlObj.beLinkImageDelete();
 *   
 * 2ch-HTML 用
 * @selecter 2chHTML (.threadクラス以降のHTML)
 */
// TODO beリンクは青文字にして残すオプションを付与
// TODO 将来的にはbeリンクを紹介ページに飛ばせるようにする
jQuery.fn.beLinkImageDelete = function() {
	/**
	 * Beリンク
	 * <dt> ～　 <a href="javascript:be(531973433);">?PLT(12350)</a></dt>
	 * Be画像
	 * <dd> <img src="http://img.2ch.net/ico/anime_wacchoi02.gif"> <br> 本文～
	 * 
	 * Beの紹介ページ
	 * http://be.2ch.net/test/p.php?i=531973433
	 */	
	
	// [Beリンク削除処理]
	// 名前欄要素を取得
	var $targets = jQuery(this).find("dt a");
	var link;
	// eachで繰り返し処理
	$targets.each(function() {
		// ddの中のリンクでhref要素がjavascript:beで始まるもの 
		link = $(this).attr("href");
		// a要素をjavascript:beでフィルタする
		if( link.indexOf("javascript:be",0) == 0){
			$(this).remove();
		}
		});
	
	// [Be画像削除処理]
	// 本文要素を取得
	var $targets = jQuery(this).find("dd");
	var $cache = null;
	// eachで繰り返し処理
	$targets.each(function() {
		// ddの中のimg要素の削除と最初のbrタグの削除
		$cache = $(this).find("img:first");
		$cache.find("br:first").remove();
		$cache.remove();		
		});
};

/**
* ttp:// のリンクを http:// にして<a>タグを付与します
*
* 例：ttp://www.good.com/01.jpg → http://www.good.com/01.jpg
*
* 2ch-HTML 用
* @selecter 2chHTML (.threadクラス以降のHTML)
*/
jQuery.fn.hyperLinkRecover = function() {
	// 本文要素を取得
	var $targets = jQuery(this).find("dd");
	
	var orign,result;
	
	// ttp://系の正規表現(http://がヒットしないように\bで回避)
	var httpRegex = /(\bttp:\/\/\w[^\s]*)\s/g;
	
	// eachで繰り返し処理
	$targets.each(function() {
		
		//本文のテキストを取得
		orign = $(this).html();
		
		//テキスト内から正規表現で検索、マッチしたらhを付与し、<a>タグをつける
		result = orign.replace(httpRegex,"<a href=\"h$1\">$1</a>");
		
		// 無駄な処理防止とバグが起きた時の被害最小化のためttpがないレス以外は書き換えない
		// DOM要素を書き換える
		if(result != orign){
			//alert(result + "★" +orign);
			$(this).html(result);
		}

	});
	return this;
};

/**
 * レスグループ（名前欄＋本文）の背景色を指定された色に変えます
 * 2ch-HTML 用
 * @selecter 2chHTML(1レスの本文ddタグ)
 * @param color 変更したい色
 */
jQuery.fn.changeResBgColor = function(color) {
	//名前欄の色を変えます
	jQuery(this).prev().css("background-color",color);
	//レス内容の色を変えます
	jQuery(this).css("background-color",color);
};

