/*
 * jquery.zweiCh2Blog.js (zwei Channel to Blog)
 * 2ch-HTMLからまとめ記事を作成した後、各種Blog用に加工するメソッド群
 * 
 * [対応Blog](予定)
 * 	はてな
 * 	FC2
 * 	livedoor
 * 
 * Jsライブラリのため2ch(HTML版)をターゲットとしています
 * 2ch(DAT版)はターゲットとしてないのでDATをHTMLに変換して当ライブラリを使用してください。
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */


/**
 * 2ch-HTMLをブログに貼り付けても文字がズレないように強制整形します。
 * dt/ddタグを削除し、Div/pタグに置き換えます。
 * 
 * 以下の各種問題を解決します
 * ・IE/FFではddタグの2行目の行頭スペースが作られないケースがあるので1行目と2行目の行頭がずれる。
 * ・各種ブログ(※)のデフォルトCSSでdt/ddの要素の定義を固定している場合に文字装飾をかってに改変され意図したスタイルにならない。
 * 　 ※はてなダイアリー等
 * 
 * Pのスタイルは本当はCSSに別定義したいがブログにそのままワンコピーするためにはPタグスタイルの
 * ハードコーティングが必要。(別定義もできるようにする)
 * 
 * Step1 <dt><dt>は削除
 * Step2 <dd></df>は<p>に置き換え
 * 
* 2ch-HTML 用
* @selecter 2chまとめ記事HTML
*/
jQuery.fn.replaceDtDd2DivP = function() {
	
	var stylePtag='<p style="margin-left:40px;margin-top:0px;margin-bottom:0px;text-indent:0em;">';
	
	var $targets = jQuery(this).find("dt");
	$targets.each(function() {
		$(this).replaceWith($(this).html());
	});
	
	$targets = jQuery(this).find("dd");
	$targets.each(function() {
		$(this).replaceWith(stylePtag + $(this).html() + "</p>");
	});
	
	return this;
};


//　(Method)横とのDIVを制限する width800とか　ユーザーが長さを指定できるようにする


// (Method)IDキャンセラー(hatena)
// 行末からID:9文字を正規表現で検索し[]$1[]を付与
// IDは先にｊQueryのフィルタ作ったほうがはやいかも
// したらばのIDはID:???　となり時間は秒数がなくYYYY:MM:DDになっている(2chはYYYY:MM:DD.SS)

// (Method)キーワードはずし(hatena)