/*
 * jquery.gbbunnyUtil.js
 * [2chMatometter]に囚われない汎用的なメソッド群 
 *
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 他のソフトウェアでも汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */

/**
 * HTMLに対しタグ境界線(><)に改行(\n)を差し込みます
 *
 * /></ -> />\n</
 * 
 * @selecter HTML
 */
jQuery.fn.insReturn4TagLine = function() {
	var orignHtml = jQuery(this).html();
	var result = orignHtml.replace(/></g,">\n<");
	jQuery(this).html(result);
	return this;
};

/**
 * HTMLに対しタグ境界と<br>に改行(\n)を差し込みます
 * @selecter HTML
 */
jQuery.fn.insertReturnCode = function() {
	var orignHtml = jQuery(this).html();
	var result = orignHtml.replace(/<br>/g,"<br>\n");
	jQuery(this).html(result);
	// 閉じタグに改行を差し込み
	jQuery(this).insReturn4TagLine();
	return this;
};


/**
 * HTMLに対し改行コード(\r\n or \n)を削除します。
 *
 * /\r\n/ -> //
 * /\n/ -> //
 * 
 * @selecter HTML
 */
jQuery.fn.deleteReturnCode = function() {
	var orignHtml = jQuery(this).html();
	var result = orignHtml.replace(/\r\n/g,"");
	result = result.replace(/\n/g,"");
	jQuery(this).html(result);
	return this;
};
