/*
 * jquery.zweiCh2Blog.js (zwei Channel to Blog)
 * 2ch-HTMLからまとめ記事を作成した後、各種Blog用に加工するメソッド群
 * 
 * [対応Blog](予定)
 * 	はてなダイアリー
 * 	FC2
 * 	livedoor
 * 
 * Jsライブラリのため2ch(HTML版)をターゲットとしています
 * 2ch(DAT版)はターゲットとしてないのでDATをHTMLに変換して当ライブラリを使用してください。
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */


/**
 * 2ch-HTMLをブログに貼り付けても文字がズレないように強制整形します。
 * dt/ddタグを削除し、Pタグに置き換えます。
 * 
 * 以下の各種問題を解決します
 * ・IE/FFではddタグの2行目の行頭スペースが作られないケースがあるので1行目と2行目の行頭がずれる。
 * ・各種ブログ(※)のデフォルトCSSでdt/ddの要素の定義を固定している場合に文字装飾をかってに改変され意図したスタイルにならない。
 * 　 ※はてなダイアリー等
 * 
 * Pのスタイルは本当はCSSに別定義したいがブログにそのままワンコピーするためにはPタグスタイルの
 * ハードコーティングが必要。(別定義もできるようにする)
 * 
 * Step1 <dt><dt>は削除
 * Step2 <dd></df>は<p>に置き換え
 * 
* 2ch-HTML 用
* @selecter 2chまとめ記事HTML
*/
jQuery.fn.replaceDtDd2DivP = function() {
	
	var stylePtag='<p style="margin-left:40px;margin-top:0px;margin-bottom:0px;text-indent:0em;">';
	
	var $targets = jQuery(this).find("dt");
	$targets.each(function() {
		$(this).replaceWith($(this).html());
	});
	
	$targets = jQuery(this).find("dd");
	$targets.each(function() {
		$(this).replaceWith(stylePtag + $(this).html() + "</p>");
	});
	
	return this;
};

/**
 * IDリンクキャンセラー (はてなダイアリー用)
 * はてなダイアリーの仕様でID:をはてなのユーザーIDと認識しリンクが貼られるため
 * [][]のリンク解除キーワードを付与します。
 *
 * 2ch-HTML 用
 * @selecter 2chまとめ記事HTML
 */
jQuery.fn.idLinkCanceler = function() {
	//STEP1  行末からID:9文字を正規表現で検索し[]$1[]を付与
	// IDは先にｊQueryのフィルタ作ったほうがはやいかも
	// したらばのIDはID:???　となり時間は秒数がなくYYYY:MM:DDになっている(2chはYYYY:MM:DD.SS)

	// スタンダード表示
	//：2012/05/05(土) 03:03:53.46 ID:lok9X8Fg0
	// ●あり
	//：2012/05/05(土) 02:59:15.69 ID:lok9X8Fg0● 
	
	var orign,result;
	var regex = /\s(ID:.{9})/;
	var regex8 = /\s(ID:.{8})/;
	
	var $targets = jQuery(this).find("dt");
	$targets.each(function() {
		//本文のテキストを取得
		orign = $(this).html();
		
		//テキスト内から正規表現で検索、マッチしたら[][]を付与
		result = orign.replace(regex,"[]$1[]");
		
		if(result === orign) {
			result = orign.replace(regex8,"[]$1[]");
		}
		
		$(this).html(result);
	});
	
	// すでにdtタグがプラグインで消されてる時の対応
	if($targets.length === 0){
		
		// gオプションを付与
		regex = /\s(ID:.{9})/g;
		regex8 = /\s(ID:.{8})/g;
		
		//本文のテキストを取得
		orign = $(this).html();
		
		//テキスト内から正規表現で検索、マッチしたら[][]を付与
		result = orign.replace(regex,"[]$1[]");
		
		if(result === orign) {
			result = orign.replace(regex8,"[]$1[]");
		}
		
		$(this).html(result);
	}
	
	return this;
};

/**
 * キーワードリンクキャンセラー (はてなダイアリー用)
 * はてなダイアリーのキーワードリンクを解除します。
 * 処理対象はdd-fontタグ内のテキストです(CLEditorでフォントいじりした後の対処)。
 * 対象の文字列に[][]のリンク解除キーワードを付与します。
 *
 * 2ch-HTML 用
 * @selecter 2chまとめ記事HTML
 */
jQuery.fn.keyWordLinkCanceler = function() {
	var orign;
	var $targets = jQuery(this).find("dd font");
	if($targets.length == 0) {
		// すでにddタグがプラグインで消されてる時の対応
		$targets = jQuery(this).find("p font");
	}
	
	
	
	$targets.each(function() {
		//本文のテキストを取得
		orign = $(this).text();
		if(!isNullBlankSpace(orign)){
			$(this).text("[]" + orign + "[]");
		}
	});
	return this;
};



/*
 * 文字列が空かNULLか未定義かスペースのみだったらTRUE
 */
function isNullBlankSpace(string) {
	// NULLか未定義か空文字
	if(!string || string.length === 0) {
		return true;
	}
	
	// スペースチェック
	var copy = jQuery.trim(string);
	if(copy.length === 0) {
		return true;
	}
	
	return false;
}