﻿/* テスト */
/*
 * File: main-fltk.cpp
 * Purpose: 
 * - Startup file for use with Fast light Toolkit.
 * - FLTK utility functions.
 *
 * Compiling:
 * - Type "/DWIN32" in Project->Properties->C/C++->Command line
 * - Add fltk lib directory to Project->Properties->Linker->Additional library directories
 * - Add fltk include directory to Project->Properties->C/C++->Additional include directories
 *
 * Notes:
 * FLTK supports unicode via UTF-8. All strings processed by FLTK functions are 
 * assumed to be in UTF-8.  When running in Windows this means that Unicode (wide) 
 * strings from the API will have to be converted to UTF-8 strings before passing 
 * to FLTK functions.
 *
 * Copyright (c) 2009 Paul Blay
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, version 2.
 */

#ifdef _UNICODE
#  include <wchar.h>
#  include <tchar.h>
#endif
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/fl_ask.H>
#include "angedit.h"
#include <string>
#include "defines.h"
#include "externs.h"

/*
 * Popup message box.
 *
 * TODO : Handle unicode and/or UTF-8.
 */

void pbox(const _TCHAR *str)
{ 
	std::string copiedstring;
#ifdef _UNICODE
	// Convert to UTF-8 from wchar_t

	copiedstring = wstr_to_str(str, CP_UTF8);

	fl_message(copiedstring.c_str());
#else
	fl_message(str);
#endif
}

int main(int argc, char **argv) 
{
	/* Initialize stuff */
	_TCHAR projdir[250]; // TODO Should be global variable?
	_TCHAR dbfile[250];
	getprojdir(projdir);

	_tcscpy_s(dbfile, 250, projdir);
	_tcscat_s(dbfile,_countof(dbfile),__T("\\lib\\edit\\INFO.db3"));

	opendatabase(dbfile);

	Fl_Window *window = new Fl_Window(300,180);
	Fl_Box *box = new Fl_Box(20,40,260,100,"Hello, World!");
	box->box(FL_UP_BOX);
	box->labelsize(36);
	box->labelfont(FL_BOLD+FL_ITALIC);
	box->labeltype(FL_SHADOW_LABEL);
	window->end();
	window->show(argc, argv);
	return Fl::run();
}
