﻿/* テスト */
/*
 * File: angedit.cpp
 * Purpose: Text data file import / export and editing
 *
 * Copyright (c) 2009 Paul Blay
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, version 2.
 *
 * Compiling:
 * - This file makes use of the fl_table library that is not included
 *   with FLTK by default.  Get fl_table from 
 *   http://www.seriss.com/people/erco/fltk/Fl_Table/
 *   and follow instructions there.
 */
#ifdef _UNICODE
#  include <tchar.h>
#  include <wchar.h>
#endif

#include <cstdio>
#include "sqlite3.h"

// Windows with VC++

#if defined(_MSC_VER) && (_MSC_VER >= 1400)
#   include <windows.h>
#endif

#include <string>
#include "angedit.h"
#include "defines.h"
#include "externs.h"

#include <FL/Fl_Table.H>

tabledata tab; // global for 'current' table.

int opendatabase(_TCHAR *dbfile)
{
	sqlite3 *db;
	int rc;
	char *pzErrmsg;
	//char allout[600] = "";

	if(!_file_exists(dbfile))
	{
		pbox(__T("テスト Database file not found"));
		return -1;
	}
	rc = _tsqlite3_open(dbfile, &db);
	if( rc )
	{
		sqlite3_close(db);
		pbox(__T("テスト Could not open database"));
		return -1;
	}
	pbox(__T("テスト Database opened"));

	// Open table global

	// Pass data from table global to a function that displays the table.

	sqlite3_get_table(db, "SELECT * FROM global", &tab.table, &tab.rows, &tab.cols, &pzErrmsg);

	//for(int i = 0; i < pnRow * pnColumn; i++)
	//{
		//strcat_s(allout, sizeof(allout), tableout[i]);
		//strcat_s(allout, sizeof(allout), " ");
	//}

	// Open [tablename].txt using field [tablename] from global.

	// Read lines from [tablename] until a) 'V' found, b) first non-'#' found.

	// Get version number.

	// Compare with entry in table global.

	// Inform if unchanged / not found / changed.

	// 'Yes/No' dialog box to update entry in Global or not.

	showtable();

	sqlite3_close(db);

	return 0;
}
